/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import eu.dnetlib.data.collector.plugins.ftp.FtpClientProvider;
import eu.dnetlib.data.collector.plugins.ftp.ItemUtility;
import eu.dnetlib.data.collector.plugins.ftp.UserSFTP;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPFile;

public class ClientSftpDataProvider
implements FtpClientProvider {
    private static final Log log = LogFactory.getLog(ClientSftpDataProvider.class);
    private Session session;
    private ChannelSftp sftpChannel;
    private int port;
    private ItemUtility itemParam;

    @Override
    public void connect() {
        try {
            JSch jsch = new JSch();
            this.port = 22;
            this.session = jsch.getSession(this.itemParam.getUsername(), this.itemParam.getHost(), this.port);
            UserSFTP muser = new UserSFTP();
            muser.setPassword(this.itemParam.getPassword());
            this.session.setUserInfo((UserInfo)muser);
            this.session.connect();
            Channel channel = this.session.openChannel("sftp");
            channel.connect();
            this.sftpChannel = (ChannelSftp)channel;
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void disconnect() {
        this.session.disconnect();
    }

    @Override
    public boolean changeWorkingDirectory(String path) {
        boolean b = false;
        try {
            this.sftpChannel.cd(path);
            b = true;
        }
        catch (SftpException e) {
            b = false;
        }
        return b;
    }

    @Override
    public FTPFile[] listFiles() {
        ArrayList<FTPFile> tmp = new ArrayList<FTPFile>();
        try {
            Vector v = this.sftpChannel.ls(this.sftpChannel.pwd());
            for (ChannelSftp.LsEntry obj : v) {
                if (obj.getFilename().startsWith(".")) continue;
                FTPFile afile = new FTPFile();
                afile.setName(obj.getFilename());
                SftpATTRS attributes = obj.getAttrs();
                if (attributes.isDir()) {
                    afile.setType(1);
                } else {
                    afile.setType(0);
                }
                tmp.add(afile);
            }
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
        FTPFile[] files = new FTPFile[tmp.size()];
        files = tmp.toArray(files);
        return files;
    }

    @Override
    public FTPFile[] listFiles(String source) {
        ArrayList<FTPFile> tmp = new ArrayList<FTPFile>();
        try {
            Vector v = this.sftpChannel.ls(source);
            for (ChannelSftp.LsEntry obj : v) {
                if (obj.getFilename().startsWith(".")) continue;
                FTPFile afile = new FTPFile();
                afile.setName(obj.getFilename());
                SftpATTRS attributes = obj.getAttrs();
                if (attributes.isDir()) {
                    afile.setType(1);
                } else {
                    afile.setType(0);
                }
                tmp.add(afile);
            }
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
        FTPFile[] files = new FTPFile[tmp.size()];
        files = tmp.toArray(files);
        return files;
    }

    @Override
    public String printWorkingDirectory() {
        String path = null;
        try {
            path = this.sftpChannel.pwd();
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
        return path;
    }

    @Override
    public String retrieveFileStream(String remote) {
        try {
            InputStream stream = this.sftpChannel.get(remote);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)stream, (Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            log.error((Object)("cannot read file: " + remote), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (SftpException e) {
            log.error((Object)("cannot read file: " + remote), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void completePendingCommand() throws IOException {
    }

    @Override
    public void setItemParam(ItemUtility itemUtility) {
        this.itemParam = itemUtility;
    }

    @Override
    public boolean isConnected() {
        return this.sftpChannel.isConnected();
    }
}

