/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import eu.dnetlib.data.collector.plugins.ftp.FtpClientProvider;
import eu.dnetlib.data.collector.plugins.ftp.ItemUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class ClientFtpDataProvider
implements FtpClientProvider {
    private static final Log log = LogFactory.getLog(ClientFtpDataProvider.class);
    private FTPClient client = new FTPClient();
    private ItemUtility itemParam;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        ClientFtpDataProvider clientFtpDataProvider = this;
        synchronized (clientFtpDataProvider) {
            try {
                this.client.connect(this.itemParam.getHost());
                this.client.enterLocalPassiveMode();
                if (!this.checkPositiveResponse()) {
                    throw new IllegalStateException("unable to connect to ftp server. " + this.itemParam.getHost());
                }
                if (!this.client.login(this.itemParam.getUsername(), this.itemParam.getPassword())) {
                    throw new IllegalStateException("unable to login to ftp server. " + this.itemParam.getHost());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to connect to ftp server. " + this.itemParam.getHost(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        ClientFtpDataProvider clientFtpDataProvider = this;
        synchronized (clientFtpDataProvider) {
            try {
                this.client.disconnect();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean changeWorkingDirectory(String path) {
        ClientFtpDataProvider clientFtpDataProvider = this;
        synchronized (clientFtpDataProvider) {
            Boolean b = false;
            try {
                b = this.client.changeWorkingDirectory(path);
            }
            catch (IOException e) {
                return false;
            }
            return b;
        }
    }

    @Override
    public FTPFile[] listFiles() {
        ClientFtpDataProvider clientFtpDataProvider = this;
        synchronized (clientFtpDataProvider) {
            try {
                return this.client.listFiles();
            }
            catch (IOException e) {
                log.error((Object)"cannot list files", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public FTPFile[] listFiles(String source) {
        ClientFtpDataProvider clientFtpDataProvider = this;
        synchronized (clientFtpDataProvider) {
            try {
                return this.client.listFiles(source);
            }
            catch (IOException e) {
                log.error((Object)"cannot list files", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public String printWorkingDirectory() {
        ClientFtpDataProvider clientFtpDataProvider = this;
        synchronized (clientFtpDataProvider) {
            try {
                return this.client.printWorkingDirectory();
            }
            catch (IOException e) {
                log.error((Object)"cannot print working directory", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public String retrieveFileStream(String remote) throws IOException {
        int nRepeat = 4;
        while (nRepeat > 0) {
            try {
                return this.doRetrieveStream(remote);
            }
            catch (IOException e) {
                log.info((Object)"An error occurred, retrying.. ({n} retries left)".replace("{n}", String.valueOf(--nRepeat)));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return "<INVALID src='" + remote + "'/>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doRetrieveStream(String remote) throws IOException {
        InputStream stream = this.client.retrieveFileStream(remote);
        StringWriter writer = new StringWriter();
        try {
            if (!this.checkPositiveResponse()) {
                throw new IllegalStateException("unable to retrieve stream from ftp server. " + this.itemParam.getHost());
            }
            IOUtils.write((byte[])IOUtils.toByteArray((InputStream)stream), (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            log.error((Object)("Exception retrieving stream from " + remote), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((InputStream)stream);
            if (!this.client.completePendingCommand()) {
                throw new IllegalStateException("unable to complete pending command on ftp server. " + this.itemParam.getHost());
            }
        }
    }

    private boolean checkPositiveResponse() throws IOException {
        int reply = this.client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply) & !FTPReply.isPositivePreliminary((int)reply) & !FTPReply.isPositiveIntermediate((int)reply)) {
            this.client.disconnect();
            log.error((Object)("FTP server refused connection. " + this.itemParam.getHost()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completePendingCommand() throws IOException {
        ClientFtpDataProvider clientFtpDataProvider = this;
        synchronized (clientFtpDataProvider) {
            this.client.completePendingCommand();
        }
    }

    @Override
    public void setItemParam(ItemUtility itemUtility) {
        this.itemParam = itemUtility;
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }
}

