/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.filesystem;

import eu.dnetlib.data.collector.plugins.filesystem.FileWalker;
import eu.dnetlib.data.collector.plugins.filesystem.FilesystemBlockingStream;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilesystemIterable
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(FilesystemIterable.class);
    private final String basePath;
    private final BlockingQueue<String> queue;
    private ExecutorService producer;
    public static final Object done = new Object();

    public FilesystemIterable(InterfaceDescriptor descriptor) throws URISyntaxException {
        this.basePath = descriptor.getBaseUrl();
        this.producer = Executors.newSingleThreadExecutor();
        this.queue = new ArrayBlockingQueue<String>(20);
    }

    @Override
    public Iterator<String> iterator() {
        this.doReadFromFTP();
        return new FilesystemBlockingStream<String>(this.queue);
    }

    private void doReadFromFTP() {
        final FileWalker<String> walker = new FileWalker<String>(this.queue, FileWalker.FileType.TEXT, this.basePath);
        this.producer.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    walker.doWalk();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                log.info((Object)("finished to iterate under " + FilesystemIterable.this.basePath));
            }
        });
    }
}

