/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.filesystem;

import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.plugins.filesystem.FilesystemIterable;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilesystemCollectorPlugin
implements CollectorPlugin {
    private static final Log log = LogFactory.getLog(FilesystemCollectorPlugin.class);

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor) throws CollectorServiceException {
        HashMap params = interfaceDescriptor.getParams();
        String baseUrl = interfaceDescriptor.getBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        try {
            return new FilesystemIterable(interfaceDescriptor);
        }
        catch (URISyntaxException e) {
            log.error((Object)"Filesystem collector failed! ", (Throwable)e);
            return null;
        }
    }

    public String getProtocol() {
        return "filesystem";
    }
}

