/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.filesystem;

import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.plugins.filesystem.FilesystemIterable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileWalker<T>
extends DirectoryWalker {
    private static final Log log = LogFactory.getLog(FileWalker.class);
    private final BlockingQueue<T> queue;
    private final File source;
    private final FileType type;
    public static String IGNORE_PREFIX = ".";
    public static String IGNORE_SUFFIX = "~";
    static IOFileFilter fileFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.orFileFilter((IOFileFilter)new SuffixFileFilter("~"), (IOFileFilter)HiddenFileFilter.HIDDEN));

    public FileWalker(BlockingQueue<T> queue, FileType type, String basePath) {
        super((FileFilter)fileFilter, -1);
        this.source = new File(basePath);
        this.type = type;
        this.queue = queue;
    }

    public void doWalk() throws IOException {
        log.info((Object)("starting to iterate " + this.type.toString() + " files under " + this.source.getAbsolutePath()));
        this.walk(this.source, this.queue);
        this.enqueue(this.queue, FilesystemIterable.done);
    }

    protected void handleFile(File file, int depth, Collection results) throws IOException {
        this.enqueue((BlockingQueue)results, this.readFile(file));
    }

    protected boolean handleDirectory(File directory, int depth, Collection results) throws IOException {
        if (directory.getName().startsWith(IGNORE_PREFIX)) {
            return false;
        }
        return super.handleDirectory(directory, depth, results);
    }

    private void enqueue(BlockingQueue<T> queue, T element) {
        try {
            queue.put(element);
        }
        catch (InterruptedException e) {
            log.warn((Object)"ops... ", (Throwable)e);
        }
    }

    private String readFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        String fileContent = null;
        switch (this.type) {
            case TEXT: {
                StringWriter sw = new StringWriter();
                IOUtils.copy((InputStream)fis, (Writer)sw);
                sw.flush();
                fileContent = sw.toString();
                if (!fileContent.startsWith("\ufeff")) break;
                fileContent = fileContent.substring(1);
                break;
            }
            default: {
                throw new UnsupportedOperationException("FileType should be one of: " + Lists.newArrayList((Object[])FileType.values()));
            }
        }
        fis.close();
        return fileContent;
    }

    public static enum FileType {
        TEXT,
        PDF,
        DOC;

    }
}

