/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins;

import au.com.bytecode.opencsv.CSVReader;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FileCSVCollectorPlugin
implements CollectorPlugin {
    private static final Log log = LogFactory.getLog(FileCSVCollectorPlugin.class);
    private String[] headers = null;
    private CSVReader reader = null;
    private int identifierNumber;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor) throws CollectorServiceException {
        String header = (String)interfaceDescriptor.getParams().get("header");
        String separator = StringEscapeUtils.unescapeJava((String)((String)interfaceDescriptor.getParams().get("separator")));
        String quote = (String)interfaceDescriptor.getParams().get("quote");
        this.identifierNumber = Integer.parseInt((String)interfaceDescriptor.getParams().get("identifier"));
        URL u = null;
        try {
            u = new URL(interfaceDescriptor.getBaseUrl());
        }
        catch (MalformedURLException e1) {
            throw new CollectorServiceException((Throwable)e1);
        }
        String baseUrl = u.getPath();
        log.info((Object)("base URL = " + baseUrl));
        try {
            this.reader = quote != null ? new CSVReader((Reader)new FileReader(baseUrl), separator.charAt(0), quote.charAt(0)) : new CSVReader((Reader)new FileReader(baseUrl), separator.charAt(0));
            if (header != null && "true".equals(header.toLowerCase())) {
                this.headers = this.reader.readNext();
            }
        }
        catch (Exception e) {
            throw new CollectorServiceException((Throwable)e);
        }
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new FileCSVIterator();
            }
        };
    }

    public String getProtocol() {
        return "fileCSV";
    }

    class FileCSVIterator
    implements Iterator<String> {
        private String next = this.calculateNext();

        FileCSVIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String next() {
            try {
                String string = this.next;
                return string;
            }
            finally {
                this.next = this.calculateNext();
            }
        }

        private String calculateNext() {
            try {
                Document document = DocumentHelper.createDocument();
                Element root = document.addElement("csvRecord");
                String[] currentRow = FileCSVCollectorPlugin.this.reader.readNext();
                if (currentRow != null) {
                    for (int i = 0; i < currentRow.length; ++i) {
                        String hAttribute = FileCSVCollectorPlugin.this.headers == null ? "column" + i : FileCSVCollectorPlugin.this.headers[i];
                        Element row = root.addElement("column");
                        if (i == FileCSVCollectorPlugin.this.identifierNumber) {
                            row.addAttribute("isID", "true");
                        }
                        row.addAttribute("name", hAttribute).addText(currentRow[i]);
                    }
                    return document.asXML();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error calculating next csv element", (Throwable)e);
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

