/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector;

import com.google.common.collect.Maps;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;

public class CollectorPluginEnumerator
implements BeanFactoryAware {
    private ListableBeanFactory beanFactory;

    public Map<String, CollectorPlugin> getAll() {
        return this.beanFactory.getBeansOfType(CollectorPlugin.class);
    }

    public Map<String, CollectorPlugin> getByProtocols() {
        HashMap res = Maps.newHashMap();
        for (CollectorPlugin cp : this.getAll().values()) {
            res.put(cp.getProtocol().toLowerCase(), cp);
        }
        return res;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public CollectorPlugin get(String protocol) throws CollectorServiceException {
        CollectorPlugin plugin = this.getByProtocols().get(protocol.toLowerCase());
        if (plugin == null) {
            throw new CollectorServiceException("plugin not found for protocol: " + protocol);
        }
        return plugin;
    }
}

