<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:dc="http://purl.org/dc/elements/1.1/">

	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes" />

	<xsl:template match="/">
		<xsl:if test="//dc:source">
			<b>Resource:</b><br />
			<ul>
			<xsl:variable name="sourceUrl" select="//dc:source"/>
	        <xsl:variable name="thumb" select="//thumbnail"/>
	        <xsl:if test="$thumb">
		        <a href="{$sourceUrl}"><img src="{$thumb}" width="150" height="150"/></a>
	        </xsl:if>			
			</ul><br />
		</xsl:if>
		<xsl:if test="//dc:title">
			<b>Titles:</b><br />
			<ul>
				<xsl:for-each select="//dc:title">
					<li><xsl:value-of select="." /></li>					
				</xsl:for-each>
			</ul><br />
		</xsl:if>
		<xsl:if test="//dc:creator">
			<b>Authors:</b><br />
			<ul>
				<xsl:for-each select="//dc:creator">
					<li><xsl:value-of select="." /></li>					
				</xsl:for-each>
			</ul><br />
		</xsl:if>
		<xsl:if test="//dc:subject">
			<b>Subjects:</b><br />
			<ul>
				<xsl:for-each select="//dc:subject">
					<li><xsl:value-of select="." /></li>					
				</xsl:for-each>
			</ul><br />
		</xsl:if>
		<xsl:if test="//dc:date">
			<b>Dates:</b><br />
			<ul>
				<xsl:for-each select="//dc:date">
					<li><xsl:value-of select="." /></li>					
				</xsl:for-each>
			</ul><br />
		</xsl:if>
		
		<xsl:if test="//dc:description">
			<b>Description:</b><br />
			<ul>
				<xsl:for-each select="//dc:description">
					<li><xsl:value-of select="." /></li>					
				</xsl:for-each>
			</ul><br />
		</xsl:if>
		
		<xsl:if test="//dr:repositoryName">
			<b>Repository Name:</b><br />
			<ul>
				<xsl:for-each select="//dr:repositoryName">
					<li><xsl:value-of select="." /></li>					
				</xsl:for-each>
			</ul><br />
		</xsl:if>
		
		<xsl:if test="//dr:repositoryCountry">
			<b>Repository Country:</b><br />
			<ul>
				<xsl:for-each select="//dr:repositoryCountry">
					<li><xsl:value-of select="." /></li>					
				</xsl:for-each>
			</ul><br />
		</xsl:if>

		<xsl:if test="//dr:repositoryInstitution">
			<b>Repository Institution:</b><br />
			<ul>
				<xsl:for-each select="//dr:repositoryInstitution">
					<li><xsl:value-of select="." /></li>					
				</xsl:for-each>
			</ul><br />
		</xsl:if>

		<xsl:if test="//dr:repositoryLink">
			<b>Repository Link:</b><br />
			<ul>
				<xsl:for-each select="//dr:repositoryLink">
					<li><a href="{.}"><xsl:value-of select="." /></a></li>					
				</xsl:for-each>
			</ul><br />
		</xsl:if>
		
	</xsl:template>


</xsl:stylesheet>
