package eu.dnetlib.actionmanager.actions;

import java.util.List;

import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;

import com.google.common.collect.Lists;

import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.actionmanager.ActionManagerConstants.ACTION_TYPE;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.hbase.HBasePutFactory;

public class AtomicAction extends AbstractAction {

	private String targetRowKey;
	private String targetColumnFamily;
	private String targetColumn;

	private byte[] targetValue;

	public AtomicAction(String set, Agent agent) {
		super(set, agent);
	}

	public AtomicAction(String set, Agent agent, Operation operation, String targetRowKey, String targetColumnFamily, String targetColumn,
			byte[] targetValue) {
		this(set, agent);
		this.targetRowKey = targetRowKey;
		this.targetColumnFamily = targetColumnFamily;
		this.targetColumn = targetColumn;
		this.targetValue = targetValue;
	}

	@Override
	public List<Put> asPutOperations(String parentId, Provenance provenance, String trust, String nsprefix) {
		final Put put = HBasePutFactory.createPutOperation(getRowKey(), getSet(), getAgent());

		put.add(ActionManagerConstants.SET_COLFAMILY, Bytes.toBytes(getSet()), Bytes.toBytes(getSet()));
		put.add(ActionManagerConstants.TARGET_COLFAMILY, ActionManagerConstants.TARGET_KEY_COL, Bytes.toBytes(targetRowKey));
		put.add(ActionManagerConstants.TARGET_COLFAMILY, ActionManagerConstants.TARGET_COLFAMILY_COL, Bytes.toBytes(targetColumnFamily));
		put.add(ActionManagerConstants.TARGET_COLFAMILY, ActionManagerConstants.TARGET_COL_COL, Bytes.toBytes(targetColumn));
		put.add(ActionManagerConstants.TARGET_COLFAMILY, ActionManagerConstants.TARGET_OAF_COL, targetValue);

		if (parentId != null && !parentId.isEmpty()) {
			put.add(ActionManagerConstants.RELATION_COLFAMILY, Bytes.toBytes(parentId), ActionManagerConstants.ISPARTOF);
		}

		return Lists.newArrayList(put);
	}

	@Override
	public ACTION_TYPE getTypology() {
		return ACTION_TYPE.aac;
	}

	public String getTargetRowKey() {
		return targetRowKey;
	}

	public void setTargetRowKey(String targetRowKey) {
		this.targetRowKey = targetRowKey;
	}

	public String getTargetColumnFamily() {
		return targetColumnFamily;
	}

	public void setTargetColumnFamily(String targetColumnFamily) {
		this.targetColumnFamily = targetColumnFamily;
	}

	public String getTargetColumn() {
		return targetColumn;
	}

	public void setTargetColumn(String targetColumn) {
		this.targetColumn = targetColumn;
	}

	public byte[] getTargetValue() {
		return targetValue;
	}

	public void setTargetValue(byte[] targetValue) {
		this.targetValue = targetValue;
	}

	@Override
	public boolean isValid() {
		return (getRowKey() != null && !getRowKey().isEmpty() && getSet() != null && !getSet().isEmpty() && targetRowKey != null
				&& !targetRowKey.isEmpty() && targetColumnFamily != null && !targetColumnFamily.isEmpty() && targetColumn != null
				&& !targetColumn.isEmpty() && targetValue != null && targetValue.length > 0);
	}

}
