package eu.dnetlib.actionmanager.actions;

import java.util.List;
import java.util.UUID;

import org.apache.hadoop.hbase.client.Put;

import com.google.common.hash.Hashing;

import eu.dnetlib.actionmanager.ActionManagerConstants.ACTION_TYPE;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Provenance;

public abstract class AbstractAction implements Action {

	private String set;
	private String rowKey;
	private Agent agent;

	public AbstractAction(String set, Agent agent) {
		super();
		this.set = set;
		this.agent = agent;
		this.rowKey = getTypology() + "|" + Hashing.md5().hashString(agent.getId()) + "|" + UUID.randomUUID();
	}

	@Override
	abstract public List<Put> asPutOperations(String infoPackageId, Provenance provenance, String trust, String nsprefix);

	@Override
	abstract public boolean isValid();

	@Override
	abstract public ACTION_TYPE getTypology();

	public String getSet() {
		return set;
	}

	public void setSet(String set) {
		this.set = set;
	}

	public String getRowKey() {
		return rowKey;
	}

	public void setRowKey(String rowKey) {
		this.rowKey = rowKey;
	}

	/**
	 * @return the agent
	 */
	public Agent getAgent() {
		return agent;
	}

	/**
	 * @param agent
	 *            the agent to set
	 */
	public void setAgent(Agent agent) {
		this.agent = agent;
	}

}
