package eu.dnetlib.actionmanager.hbase;

import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;

import eu.dnetlib.actionmanager.ActionManagerConstants;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.miscutils.datetime.DateUtils;

public class HBasePutFactory {
	public static Put createPutOperation(String key, String set, Agent agent) {
		final long date = DateUtils.now();
		final String dateS = DateUtils.calculate_ISO8601(date);
		final Put put = new Put(Bytes.toBytes(key));
		put.add(ActionManagerConstants.SET_COLFAMILY, Bytes.toBytes(set), Bytes.toBytes(set));
		put.add(ActionManagerConstants.DATE_COLFAMILY, Bytes.toBytes(Long.toString(date)), Bytes.toBytes(dateS));

		put.add(ActionManagerConstants.AGENT_COLFAMILY, ActionManagerConstants.AGENT_ID_COL, Bytes.toBytes(agent.getId()));
		put.add(ActionManagerConstants.AGENT_COLFAMILY, ActionManagerConstants.AGENT_NAME_COL, Bytes.toBytes(agent.getName()));
		put.add(ActionManagerConstants.AGENT_COLFAMILY, ActionManagerConstants.AGENT_TYPE_COL, Bytes.toBytes(agent.getType().toString()));
		return put;
	}
}
