package eu.dnetlib.actionmanager;

import org.apache.hadoop.hbase.util.Bytes;

public class ActionManagerConstants {

	public static enum COLUMN_FAMILIES {
		action, rel, status, set, target, operation, date, agent
	}

	public static enum ACTION_TYPE {
		aac, //atomicAction, 
		pkg, //infoPackage, 
		all //all
	}

	public static final byte[] ACTION_COLFAMILY = Bytes.toBytes(COLUMN_FAMILIES.action.toString());
	public static final byte[] RELATION_COLFAMILY = Bytes.toBytes(COLUMN_FAMILIES.rel.toString());
	public static final byte[] STATUS_COLFAMILY = Bytes.toBytes(COLUMN_FAMILIES.status.toString());
	public static final byte[] SET_COLFAMILY = Bytes.toBytes(COLUMN_FAMILIES.set.toString());
	public static final byte[] TARGET_COLFAMILY = Bytes.toBytes(COLUMN_FAMILIES.target.toString());
	public static final byte[] OPERATION_COLFAMILY = Bytes.toBytes(COLUMN_FAMILIES.operation.toString());
	public static final byte[] DATE_COLFAMILY = Bytes.toBytes(COLUMN_FAMILIES.date.toString());
	public static final byte[] AGENT_COLFAMILY = Bytes.toBytes(COLUMN_FAMILIES.agent.toString());

	public static final byte[] OPERATION_COL = Bytes.toBytes("operation");
	public static final byte[] TARGET_KEY_COL = Bytes.toBytes("rowKey");
	public static final byte[] TARGET_COLFAMILY_COL = Bytes.toBytes("columnFamily");
	public static final byte[] TARGET_COL_COL = Bytes.toBytes("column");
	public static final byte[] TARGET_OAF_COL = Bytes.toBytes("content");
	public static final byte[] HASPARTS = Bytes.toBytes("hasParts");
	public static final byte[] ISPARTOF = Bytes.toBytes("isPartOf");

	public static final byte[] AGENT_ID_COL = Bytes.toBytes("id");
	public static final byte[] AGENT_NAME_COL = Bytes.toBytes("name");
	public static final byte[] AGENT_TYPE_COL = Bytes.toBytes("type");

}
