package eu.dnetlib.dlms.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import eu.dnetlib.dlms.rmi.DLMSBrokenConnectionException;
import eu.dnetlib.dlms.rmi.DLMSBrokenConnectionRuntimeException;
import eu.dnetlib.dlms.rmi.DLMSConnectionException;
import eu.dnetlib.dlms.rmi.DLMSConnectionRuntimeException;
import eu.dnetlib.dlms.rmi.StatementDescription;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;

public class WSRemoteStatement implements Statement {

	private final WSRemoteConnection connection;
	private ResultSetService resultSet;
	private String rsId;

	private final ServiceResolver serviceResolver;

	public WSRemoteStatement(final ServiceResolver serviceResolver, final WSRemoteConnection connection) {
		super();
		this.serviceResolver = serviceResolver;
		this.connection = connection;
	}

	public ResultSet getResultSet() throws SQLException {
		if (this.resultSet == null)
			throw new SQLException("statement not executed yet, cannot get resultset");
		return new WSRemoteResultSet(this, this.resultSet, this.rsId);
	}

	public boolean execute(final String source) throws SQLException {
		final StatementDescription statement = new StatementDescription();
		statement.setSource(source);

		this.remoteExecute(statement);

		return true;
	}

	public ResultSet executeQuery(final String source) throws SQLException {
		if (this.execute(source))
			return this.getResultSet();
		else
			throw new SQLException("Cannot get ResultSet for " + source);
	}

	protected void remoteExecute(final StatementDescription statement) {
		W3CEndpointReference epr;
		try {
			epr = this.connection.getConnectionService().executeStatement(this.connection.getConnectionId(), statement);

			this.resultSet = this.serviceResolver.getService(ResultSetService.class, epr);
			this.rsId = this.serviceResolver.getResourceIdentifier(epr);
		} catch (final DLMSBrokenConnectionException e) {
			throw new DLMSBrokenConnectionRuntimeException(e.getMessage(), e.getCause());
		} catch (final DLMSConnectionException e) {
			throw new DLMSConnectionRuntimeException(e.getMessage(), e.getCause());
		}
	}

	public void addBatch(final String arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public void cancel() throws SQLException {
		// TODO Auto-generated method stub

	}

	public void clearBatch() throws SQLException {
		// TODO Auto-generated method stub

	}

	public void clearWarnings() throws SQLException {
		// TODO Auto-generated method stub

	}

	public void close() throws SQLException {
		// TODO Auto-generated method stub

	}

	public boolean execute(final String arg0, final int arg1) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean execute(final String arg0, final int[] arg1) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean execute(final String arg0, final String[] arg1) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	public int[] executeBatch() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	public int executeUpdate(final String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public int executeUpdate(final String arg0, final int arg1) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public int executeUpdate(final String arg0, final int[] arg1) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public int executeUpdate(final String arg0, final String[] arg1) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public Connection getConnection() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	public int getFetchDirection() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public int getFetchSize() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public ResultSet getGeneratedKeys() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	public int getMaxFieldSize() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public int getMaxRows() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public boolean getMoreResults() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean getMoreResults(final int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	public int getQueryTimeout() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public int getResultSetConcurrency() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public int getResultSetHoldability() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public int getResultSetType() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public int getUpdateCount() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public SQLWarning getWarnings() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean isClosed() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean isPoolable() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	public void setCursorName(final String arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public void setEscapeProcessing(final boolean arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public void setFetchDirection(final int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public void setFetchSize(final int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public void setMaxFieldSize(final int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public void setMaxRows(final int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public void setPoolable(final boolean arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public void setQueryTimeout(final int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	public boolean isWrapperFor(final Class<?> arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	public <T> T unwrap(final Class<T> arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

}
