package eu.dnetlib.dlms.jdbc;

/**
 * Client side information object reference, basically contains an id.
 * 
 * @author marko
 * 
 */
public class InformationObjectReference implements InformationObject {

	private long id;
	private String type;
	private String set;

	static protected long parseId(final String descriptor) {
		return Long.parseLong(descriptor.split(",")[0]);
	}

	static protected String parseType(final String descriptor) {
		if (descriptor.contains(","))
			return descriptor.split(",")[1];
		return "unknown";
	}

	static protected String parseSet(final String descriptor) {
		if (descriptor.contains(",")) {
			final String[] splitted = descriptor.split(",");
			if (splitted.length >= 3)
				return splitted[2];
		}
		return "unknown";
	}

	public InformationObjectReference(final String descriptor) {
		this(parseId(descriptor), parseType(descriptor), parseSet(descriptor));
	}

	public InformationObjectReference(final long id, final String type, final String set) {
		super();
		this.id = id;
		this.type = type;
		this.set = set;
	}

	public long getId() {
		return this.id;
	}

	public void setId(final long id) {
		this.id = id;
	}

	public String getType() {
		return this.type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public void setSet(final String set) {
		this.set = set;
	}

	public String getSet() {
		return this.set;
	}

}
