package eu.dnetlib.dlms.jdbc;

/**
 * Represents an information object obtained through the dlms interface. Descriptor string are in the format
 * id,typeName,setName .
 * 
 * @author marko
 * 
 */
public interface InformationObject {
	void setId(long id);

	long getId();

	/**
	 * Gets the name of the abstract type of the object.
	 * 
	 * @return the abstract type name
	 */
	String getType();

	void setType(String type);

	/**
	 * Gets the name of the concrete type (i.e. the set) of the object.
	 * 
	 * @return the concrete type name
	 */
	String getSet();

	void setSet(String setName);

}
