/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.template;

import eu.dnetlib.springutils.template.BeanTemplate;
import eu.dnetlib.springutils.template.BeanTemplateDao;
import eu.dnetlib.springutils.template.TemplateInstance;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class TemplateInstanceDefinitionParser
implements BeanDefinitionParser {
    private static final Log log = LogFactory.getLog(TemplateInstanceDefinitionParser.class);
    private BeanTemplateDao templateDao;

    public TemplateInstanceDefinitionParser(BeanTemplateDao templateDao) {
        this.templateDao = templateDao;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        TemplateInstance instance = new TemplateInstance(element, parserContext);
        String templateName = instance.getTemplateName();
        log.debug((Object)("parsing tempate INSTANCE: " + templateName));
        BeanTemplate template = this.templateDao.getTemplate(templateName);
        log.debug((Object)("found template: " + template));
        if (template == null) {
            this.stageInstance(instance);
        } else {
            instance.instantiate(template);
        }
        return null;
    }

    private void stageInstance(TemplateInstance instance) {
        this.templateDao.registerTemplateInstance(instance);
    }
}

