/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.condbean;

import eu.dnetlib.springutils.condbean.ConditionExpressionParser;
import eu.dnetlib.springutils.condbean.PropertyFinder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrivialConditionExpressionParser
implements ConditionExpressionParser {
    private static final Log log = LogFactory.getLog(TrivialConditionExpressionParser.class);
    public static final String PH_PREFIX = "${";
    public static final String PH_SUFFIX = "}";
    private PropertyFinder finder;

    @Override
    public boolean expressionValue(String expression) {
        log.debug((Object)("EXPRESSION: " + expression));
        log.debug((Object)("EXPRESSION VALUE: " + this.getProperty(expression)));
        return !StringUtils.isEmpty((String)this.getProperty(expression));
    }

    protected String getProperty(String strVal) {
        if (StringUtils.isEmpty((String)strVal)) {
            return null;
        }
        if (strVal.startsWith(PH_PREFIX) && strVal.endsWith(PH_SUFFIX)) {
            return this.basicGetProperty(strVal.substring(PH_PREFIX.length(), strVal.length() - PH_SUFFIX.length()));
        }
        return this.basicGetProperty(strVal);
    }

    protected String basicGetProperty(String name) {
        return this.finder.getProperty(name);
    }

    protected String xxbasicGetProperty(String name) {
        Properties props = new Properties();
        try {
            InputStream input = TrivialConditionExpressionParser.class.getResourceAsStream("/eu/dnetlib/cnr-default.properties");
            if (input == null) {
                log.warn((Object)"cannot open properties (null)");
            } else {
                props.load(input);
            }
        }
        catch (IOException e) {
            log.warn((Object)"cannot open properties", (Throwable)e);
        }
        String res = props.getProperty(name);
        if (res != null && !res.isEmpty()) {
            return res;
        }
        return System.getProperty(name);
    }

    public PropertyFinder getFinder() {
        return this.finder;
    }

    public void setFinder(PropertyFinder finder) {
        this.finder = finder;
    }
}

