/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.condbean;

import com.google.common.collect.Lists;
import eu.dnetlib.springutils.condbean.ChainPropertyFinder;
import eu.dnetlib.springutils.condbean.PropertyFinder;
import eu.dnetlib.springutils.condbean.ResourcePropertyFinder;
import eu.dnetlib.springutils.condbean.SystemPropertiesFinder;
import eu.dnetlib.springutils.condbean.parser.CondBeanParser;
import eu.dnetlib.springutils.condbean.parser.RunccExpressionParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConditionalBeanDefinitionParser
implements BeanDefinitionParser {
    private static final Log log = LogFactory.getLog(ConditionalBeanDefinitionParser.class);
    private transient RunccExpressionParser expressionParser = null;

    public void init(ResourceLoader resourceLoader) {
        if (this.expressionParser != null) {
            return;
        }
        ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        ChainPropertyFinder chain = new ChainPropertyFinder();
        ResourcePropertyFinder res1 = new ResourcePropertyFinder();
        res1.setResource(resolver.getResource("classpath:/eu/dnetlib/cnr-default.properties"));
        ResourcePropertyFinder res2 = new ResourcePropertyFinder();
        res2.setResource(resolver.getResource("classpath:/eu/dnetlib/cnr-site.properties"));
        ResourcePropertyFinder res3 = new ResourcePropertyFinder();
        res3.setResource(resolver.getResource("classpath:/cnr-override.properties"));
        chain.setFinders(Lists.newArrayList((Object[])new PropertyFinder[]{new SystemPropertiesFinder(), res3, res2, res1}));
        CondBeanParser condBeanParser = new CondBeanParser();
        condBeanParser.setPropertyFinder(chain);
        this.expressionParser = new RunccExpressionParser();
        this.expressionParser.setCondBeanParser(condBeanParser);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String test;
        this.init(parserContext.getReaderContext().getResourceLoader());
        if (DomUtils.nodeNameEquals((Node)element, (String)"cond") && this.expressionParser.expressionValue(test = element.getAttribute("test"))) {
            Element beanElement = DomUtils.getChildElementByTagName((Element)element, (String)"bean");
            return this.parseAndRegisterBean(beanElement, parserContext);
        }
        return null;
    }

    private BeanDefinition parseAndRegisterBean(Element element, ParserContext parserContext) {
        if (element == null) {
            throw new IllegalStateException("trying to register a null bean");
        }
        BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
        BeanDefinitionHolder holder = delegate.parseBeanDefinitionElement(element);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
        holder = delegate.decorateBeanDefinitionIfRequired(element, holder);
        return holder.getBeanDefinition();
    }
}

