/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.aop;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class MethodCacheInterceptor
implements MethodInterceptor,
InitializingBean {
    private static final Log log = LogFactory.getLog(MethodCacheInterceptor.class);
    private transient Cache cache;
    private boolean writeOnly = false;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.cache, (String)"A cache is required. Use setCache(Cache) to provide one.");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String targetName = invocation.getThis().getClass().getName();
        String methodName = invocation.getMethod().getName();
        Object[] arguments = invocation.getArguments();
        log.debug((Object)("looking for method result in cache: " + this.isWriteOnly()));
        String cacheKey = this.getCacheKey(targetName, methodName, arguments);
        Element element = this.cache.get((Serializable)((Object)cacheKey));
        if (element == null || this.isWriteOnly()) {
            log.debug((Object)"calling intercepted method");
            Object result = invocation.proceed();
            log.debug((Object)"caching result");
            element = new Element((Serializable)((Object)cacheKey), (Serializable)result);
            this.cache.put(element);
        } else {
            log.debug((Object)"found in method cache");
        }
        return element.getValue();
    }

    private String getCacheKey(String targetName, String methodName, Object[] arguments) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(targetName).append('.').append(methodName);
        if (arguments != null && arguments.length != 0) {
            for (int i = 0; i < arguments.length; ++i) {
                sbuf.append('.').append(arguments[i]);
            }
        }
        return sbuf.toString();
    }

    public boolean isWriteOnly() {
        return this.writeOnly;
    }

    public void setWriteOnly(boolean writeOnly) {
        this.writeOnly = writeOnly;
    }
}

