/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.springutils.stringtemplate;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.antlr.stringtemplate.AutoIndentWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class StringTemplateView
extends AbstractUrlBasedView {
    private static final Log log = LogFactory.getLog(StringTemplateView.class);
    private StringTemplate stringTemplate;

    public void setStringTemplate(StringTemplate value) {
        this.stringTemplate = value;
    }

    public StringTemplate getStringTemplate() {
        return this.stringTemplate;
    }

    protected void exposeToModel(Map model) {
        if (this.isThemed()) {
            this.exposeTheme(model);
            this.exposeErrors(model);
        }
    }

    protected boolean isThemed() {
        return false;
    }

    private RequestContext getRequestContext(Map<String, Object> model) {
        return (RequestContext)model.get("rc");
    }

    private void exposeTheme(Map model) {
        RequestContext context = this.getRequestContext(model);
        model.put("cssFile", context.getThemeMessage("css"));
    }

    private void exposeErrors(Map model) {
        RequestContext context = this.getRequestContext(model);
        Errors errors = context.getErrors("command");
        if (errors == null) {
            return;
        }
        HashMap<String, String> errorMap = new HashMap<String, String>();
        for (FieldError error : errors.getAllErrors()) {
            String field = error.getField();
            String objectName = error.getObjectName();
            BindStatus bind = context.getBindStatus(objectName + "." + field);
            String message = bind.getErrorMessage();
            errorMap.put(field, message);
        }
        model.put("errors", errorMap);
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (response.getContentType() == null) {
            response.setContentType(this.getContentType());
        }
        this.exposeToModel(model);
        this.logModel(model);
        this.stringTemplate.setAttributes(model);
        this.stringTemplate.write((StringTemplateWriter)new AutoIndentWriter((Writer)response.getWriter()));
    }

    private void logModel(Map model) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Environment contains:");
            for (Object key : model.keySet()) {
                log.debug((Object)("model[" + key + "] = " + model.get(key)));
            }
            log.debug((Object)"");
        }
    }
}

