<?xml version="1.0" encoding="UTF-8"?>
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema">
	<xs:element name="USED_DISKSPACE" type="xs:int"/>
	<xs:element name="TYPOLOGY" type="xs:string"/>
	<xs:element name="MASTER" type="xs:boolean"/>
	<xs:element name="THROUGHPUT" type="xs:double"/>
	<xs:element name="STATUS">
		<xs:complexType mixed="true">
			<xs:all minOccurs="0">
				<xs:element ref="MASTER" minOccurs="0"/>
				<xs:element ref="HANDLED_DATASTRUCTURE"/>
				<xs:element ref="USED_DISKSPACE"/>
				<xs:element name="LAST_UPDATE" type="LAST_UPDATEType"/>
			</xs:all>
		</xs:complexType>
	</xs:element>
	<xs:element name="ACTION_STATUS">
		<xs:simpleType>
			<xs:restriction base="xs:string">
				<xs:enumeration value="DONE"/>
				<xs:enumeration value="ONGOING"/>
				<xs:enumeration value="FAILED"/>
				<xs:enumeration value="WAITING"/>
				<xs:enumeration value="ASSIGNED"/>
			</xs:restriction>
		</xs:simpleType>
	</xs:element>
	<xs:element name="SECURITY_PARAMETERS" type="xs:string"/>
	<xs:element name="RESPONSE_TIME" type="xs:int"/>
	<xs:element name="RESOURCE_PROFILE">
		<xs:complexType>
			<xs:sequence>
				<xs:element name="HEADER" type="HEADERType"/>
				<xs:element name="BODY" type="BODYType"/>
			</xs:sequence>
		</xs:complexType>
	</xs:element>

  <xs:complexType name="RESOURCE_TYPEType">
                <xs:attribute name="value" use="required">
                        <xs:simpleType>
                                <xs:restriction base="xs:string">
                                        <xs:enumeration value="$resourceType$"/>
                                </xs:restriction>
                        </xs:simpleType>
                </xs:attribute>
  </xs:complexType>
	<xs:complexType name="RESOURCE_URIType">
		<xs:attribute name="value" type="xs:string" use="required"/>
	</xs:complexType>
	 <xs:complexType name="RESOURCE_KINDType">
                <xs:attribute name="value" use="required">
                        <xs:simpleType>
                                <xs:restriction base="xs:string">
                                        <xs:enumeration value="ServiceResources"/>
                                        <xs:enumeration value="PendingServiceResources"/>
                                </xs:restriction>
                        </xs:simpleType>
                </xs:attribute>
  </xs:complexType>
	<xs:complexType name="RESOURCE_IDENTIFIERType">
		<xs:attribute name="value" type="xs:string" use="required"/>
	</xs:complexType>
	<xs:complexType name="PARENT_IDType">
		<xs:attribute name="value" type="xs:string" use="required"/>
		<xs:attribute name="type" type="xs:string" use="required"/>
	</xs:complexType>
	<xs:complexType name="DATE_OF_CREATIONType">
		<xs:attribute name="value" type="xs:dateTime" use="required"/>
	</xs:complexType>
	<xs:complexType name="LAST_UPDATEType">
		<xs:attribute name="value" type="xs:dateTime" use="required"/>
	</xs:complexType>
	<xs:complexType name="PROTOCOLType">
		<xs:attribute name="name" type="xs:string" use="required"/>
		<xs:attribute name="address" type="xs:string" use="required"/>
	</xs:complexType>
	<xs:complexType name="PROTOCOLSType">
		<xs:sequence>
			<xs:element name="PROTOCOL" type="PROTOCOLType" maxOccurs="unbounded"/>
		</xs:sequence>
	</xs:complexType>
	<xs:element name="QOS">
		<xs:complexType>
			<xs:all>
				<xs:element ref="AVAILABILITY"/>
				<xs:element ref="CAPACITY"/>
				<xs:element ref="RESPONSE_TIME"/>
				<xs:element ref="THROUGHPUT"/>
			</xs:all>
		</xs:complexType>
	</xs:element>
	<xs:complexType name="MESSAGEType">
		<xs:sequence>
			<xs:element ref="ACTION"/>
			<xs:element name="PARAMETER" type="PARAMETERType" minOccurs="0" maxOccurs="unbounded"/>
			<xs:element ref="ACTION_STATUS"/>
		</xs:sequence>
		<xs:attribute name="id" type="xs:string" use="required"/>
		<xs:attribute name="date" type="xs:dateTime" use="required"/>
	</xs:complexType>
	<xs:complexType name="PARAMETERType">
		<xs:attribute name="name" type="xs:string" use="required"/>
		<xs:attribute name="value" type="xs:string" use="required"/>
	</xs:complexType>


	<xs:complexType name="SERVICEPROPERTIESType">
		<xs:sequence>
			<xs:element name="PROPERTY" type="PROPERTYType" minOccurs="0" maxOccurs="unbounded" />
		</xs:sequence>
	</xs:complexType>

	<xs:complexType name="PROPERTYType">
		<xs:attribute name="key"   type="xs:string" use="required" />
		<xs:attribute name="value" type="xs:string" use="required" />
	</xs:complexType>

	<xs:element name="MAX_SIZE_OF_DATASTRUCTURE" type="xs:int"/>
	<xs:element name="MAX_NUMBER_OF_DATASTRUCTURE" type="xs:int"/>
	<xs:complexType name="HEADERType">
		<xs:all>
			<xs:element name="RESOURCE_IDENTIFIER" type="RESOURCE_IDENTIFIERType"/>
			<xs:element name="RESOURCE_TYPE" type="RESOURCE_TYPEType"/>
			<xs:element name="RESOURCE_KIND" type="RESOURCE_KINDType"/>
			<xs:element name="RESOURCE_URI" type="RESOURCE_URIType"/>
			<xs:element name="PARENT_ID" type="PARENT_IDType" minOccurs="0"/>
			<xs:element name="DATE_OF_CREATION" type="DATE_OF_CREATIONType"/>
			<xs:element name="PROTOCOLS" type="PROTOCOLSType"/>
		</xs:all>
	</xs:complexType>
	<xs:element name="HANDLED_DATASTRUCTURE" type="xs:int"/>
	<xs:element name="CONFIGURATION">
		<xs:complexType>
			<xs:all>
				<xs:element ref="TYPOLOGY"/>
				<xs:element ref="MAX_SIZE_OF_DATASTRUCTURE"/>
				<xs:element ref="AVAILABLE_DISKSPACE"/>
				<xs:element ref="MAX_NUMBER_OF_DATASTRUCTURE"/>
				<xs:element name="SERVICE_PROPERTIES" type="SERVICEPROPERTIESType" minOccurs="0"/>
			</xs:all>
		</xs:complexType>
	</xs:element>
	<xs:element name="CAPACITY" type="xs:string"/>
	<xs:complexType name="BLACKBOARD_LASTType">
    <xs:simpleContent>
      <xs:extension base="xs:string">
        <xs:attribute name="date" type="xs:string"/>
      </xs:extension>
    </xs:simpleContent>
	</xs:complexType>
	<xs:complexType name="BLACKBOARDType">
		<xs:sequence>
			<xs:element name="LAST_REQUEST" type="BLACKBOARD_LASTType" minOccurs="1" maxOccurs="1"/>
			<xs:element name="LAST_RESPONSE" type="BLACKBOARD_LASTType" minOccurs="1" maxOccurs="1"/>
			<xs:element name="MESSAGE" type="MESSAGEType" minOccurs="0" maxOccurs="unbounded"/>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="BODYType">
		<xs:all>
			<xs:element ref="CONFIGURATION"/>
			<xs:element ref="STATUS"/>
			<xs:element ref="QOS"/>
			<xs:element ref="SECURITY_PARAMETERS"/>
			<xs:element ref="BLACKBOARD"/>
		</xs:all>
	</xs:complexType>
	<xs:element name="BLACKBOARD" type="BLACKBOARDType"/>
	<xs:element name="AVAILABLE_DISKSPACE" type="xs:int"/>
	<xs:element name="AVAILABILITY" type="xs:string"/>
	<xs:element name="ACTION" type="xs:string"/>
</xs:schema>
