/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools.registration;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.HNMLocator;
import eu.dnetlib.enabling.tools.NullHNMLocator;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.registration.InterfaceServiceNameResolver;
import eu.dnetlib.enabling.tools.registration.ServiceNameResolver;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.Endpoint;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ServiceRegistrator {
    private static final int SECOND = 0;
    private static final Log log = LogFactory.getLog(ServiceRegistrator.class);
    private ServiceLocator<ISRegistryService> registryLocator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private HNMLocator hnmLocator = new NullHNMLocator();
    private Map<String, String> serviceProperties = new HashMap<String, String>();
    private ServiceNameResolver serviceNameResolver = new InterfaceServiceNameResolver();

    public void registerServiceSchema(Object service) {
        this.registerServiceSchema(this.serviceNameResolver.getName(service));
    }

    public void registerServiceSchema(String serviceName) {
        try {
            InputStream schemaStream = this.getClass().getResourceAsStream("ServiceProfileSchemaTemplate.st");
            if (schemaStream == null) {
                throw new IllegalStateException("cannot find service profile schema template");
            }
            StringWriter schemaBuffer = new StringWriter();
            IOUtils.copy((InputStream)schemaStream, (Writer)schemaBuffer);
            StringTemplate schema = new StringTemplate(schemaBuffer.toString());
            String resourceType = serviceName + "ResourceType";
            schema.setAttribute("resourceType", (Object)resourceType);
            this.registryLocator.getService().addResourceType(resourceType, schema.toString());
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException("cannot register service profile schema", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot read service profile schema template", e);
        }
    }

    public String registerService(Object service, Endpoint endpoint) {
        return this.registerService(this.serviceNameResolver.getName(service), endpoint);
    }

    public String registerService(String serviceName, Endpoint endpoint) {
        return this.registerService(serviceName, this.eprBuilder.getEndpointReference((Object)endpoint));
    }

    public String registerService(String serviceName, W3CEndpointReference epr) {
        this.ensureSchemaExists(serviceName);
        DOMResult result = new DOMResult();
        epr.writeTo((Result)result);
        try {
            InputStream templateStream = this.getClass().getResourceAsStream("ServiceProfileTemplate.st");
            if (templateStream == null) {
                throw new IllegalStateException("cannot find service profile template");
            }
            StringWriter buffer = new StringWriter();
            IOUtils.copy((InputStream)templateStream, (Writer)buffer);
            StringTemplate templ = new StringTemplate(buffer.toString());
            String resourceType = serviceName + "ResourceType";
            String address = result.getNode().getChildNodes().item(0).getChildNodes().item(0).getTextContent();
            String hnmId = this.hnmLocator.getHNMForUrl(address);
            if (hnmId == null) {
                return null;
            }
            templ.setAttribute("resourceType", (Object)resourceType);
            templ.setAttribute("serviceName", (Object)serviceName);
            templ.setAttribute("address", (Object)address);
            templ.setAttribute("parentId", (Object)hnmId);
            templ.setAttribute("properties", this.serviceProperties);
            log.debug((Object)("template: " + templ.toString()));
            String res = this.registryLocator.getService().insertProfileForValidation(resourceType, templ.toString());
            Thread.sleep(0L);
            return res;
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot load service profile template", e);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException("cannot register service profile", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("cannot wait for register service profile", e);
        }
    }

    protected void ensureSchemaExists(String serviceName) {
        try {
            this.lookupLocator.getService().getResourceProfileByQuery("//*[local-name() = 'complexType' and @name = 'RESOURCE_TYPEType']//*[local-name() = 'enumeration' and @value = '" + serviceName + "ResourceType']");
            log.warn((Object)("schema for " + serviceName + " appears to exist"));
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.warn((Object)("registering schema for " + serviceName));
            this.registerServiceSchema(serviceName);
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
    }

    public String validateProfile(String profId, Endpoint endpoint) {
        try {
            Thread.sleep(0L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("interrupted", e);
        }
        try {
            return this.getRegistryLocator().getService().validateProfile(profId);
        }
        catch (ISRegistryException e) {
            throw new IllegalStateException("cannot validate service profile", e);
        }
    }

    public String validateProfile(String profId) {
        return this.validateProfile(profId, null);
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    @Required
    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public HNMLocator getHnmLocator() {
        return this.hnmLocator;
    }

    public void setHnmLocator(HNMLocator hnmLocator) {
        this.hnmLocator = hnmLocator;
    }

    public ServiceNameResolver getServiceNameGen() {
        return this.serviceNameResolver;
    }

    public void setServiceNameGen(ServiceNameResolver serviceNameGen) {
        this.serviceNameResolver = serviceNameGen;
    }

    public ServiceNameResolver getServiceNameResolver() {
        return this.serviceNameResolver;
    }

    public void setServiceNameResolver(ServiceNameResolver serviceNameRes) {
        this.serviceNameResolver = serviceNameRes;
    }

    public Map<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(Map<String, String> serviceProperties) {
        this.serviceProperties = serviceProperties;
    }
}

