/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.collections.PositionalStringMapGenerator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;

public class SplittedQueryExecutor {
    private ServiceLocator<ISLookUpService> lookupLocator;

    public SplittedQueryExecutor() {
    }

    public SplittedQueryExecutor(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public <X> Iterable<X> query(Class<X> clazz, String query) {
        return this.query(clazz, query, ":-:");
    }

    public <X> Iterable<X> query(Class<X> clazz, String query, String separator) {
        return new PositionalStringMapGenerator((Object[])new String[0]).split(clazz, this.performQuery(query), separator);
    }

    public Iterable<Map<String, String>> query(String query, String ... keys) {
        return new PositionalStringMapGenerator((Object[])keys).split(this.performQuery(query), ":-:");
    }

    public Iterable<Map<String, String>> mutableQuery(String query, String ... keys) {
        return Lists.newArrayList(this.query(query, keys));
    }

    public <X> Iterable<X> mutableQuery(Class<X> clazz, String query) {
        return Lists.newArrayList(this.query(clazz, query));
    }

    public <X> Iterable<X> mutableQuery(Class<X> clazz, String query, String separator) {
        return Lists.newArrayList(this.query(clazz, query, separator));
    }

    public List<String> performQuery(String query) {
        try {
            return this.lookupLocator.getService().quickSearchProfile(query);
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
    }

    public String queryFirst(String query) {
        try {
            return this.lookupLocator.getService().getResourceProfileByQuery(query);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            return null;
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException(e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

