/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import eu.dnetlib.enabling.tools.ServiceLocator;
import java.util.Collection;

public class ServiceLocatorChain<T>
implements ServiceLocator<T> {
    private Collection<ServiceLocator<T>> locators;

    @Override
    public T getService() {
        IllegalStateException lastException = null;
        for (ServiceLocator<T> locator : this.locators) {
            try {
                return locator.getService();
            }
            catch (IllegalStateException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new IllegalStateException("cannot find any matching service. Last locator in the chain reported as cause", lastException);
        }
        throw new IllegalStateException("cannot find any matching service: the service locator chain is empty");
    }

    public Collection<ServiceLocator<T>> getLocators() {
        return this.locators;
    }

    public void setLocators(Collection<ServiceLocator<T>> locators) {
        this.locators = locators;
    }
}

