/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.tools;

import edu.emory.mathcs.backport.java.util.Collections;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.DefaultServiceLocatorLocationScorer;
import eu.dnetlib.enabling.tools.DynamicServiceEnumerator;
import eu.dnetlib.enabling.tools.DynamicServiceLocatorLocationScorer;
import eu.dnetlib.enabling.tools.ServiceEnumerator;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.enabling.tools.ServiceRunningInstance;
import eu.dnetlib.enabling.tools.registration.ServiceNameResolver;
import eu.dnetlib.soap.cxf.StandaloneCxfEndpointReferenceBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class DynamicServiceLocator<T>
implements ServiceLocator<T> {
    private static final Log log = LogFactory.getLog(DynamicServiceLocator.class);
    private Class<T> clazz;
    private ServiceLocator<ISLookUpService> lookUpLocator;
    @Resource
    private ServiceNameResolver serviceNameResolver;
    @Resource
    private StandaloneCxfEndpointReferenceBuilder eprBuilder;
    private ServiceResolver serviceResolver;
    private DynamicServiceLocatorLocationScorer scorer;
    private ServiceEnumerator<T> enumerator;

    @PostConstruct
    protected void init() {
        Object tmp;
        if (this.scorer == null) {
            tmp = new DefaultServiceLocatorLocationScorer();
            ((DefaultServiceLocatorLocationScorer)tmp).setEprBuilder(this.eprBuilder);
            this.scorer = tmp;
        }
        if (this.enumerator == null) {
            tmp = new DynamicServiceEnumerator<T>(this.clazz);
            ((DynamicServiceEnumerator)tmp).setLookUpLocator(this.lookUpLocator);
            ((DynamicServiceEnumerator)tmp).setServiceNameResolver(this.serviceNameResolver);
            ((DynamicServiceEnumerator)tmp).setEprBuilder(this.eprBuilder);
            this.enumerator = tmp;
        }
    }

    @Override
    public T getService() {
        List<ServiceRunningInstance<T>> candidates;
        String serviceName = this.serviceNameResolver.getName(this.clazz);
        log.debug((Object)("searching for service: " + serviceName));
        if (this.enumerator == null) {
            log.warn((Object)("Enumerator is null in " + this + ". Postconstruct not called by spring, please check. Now called manually to workaround this problem"));
            this.init();
        }
        if ((candidates = this.enumerator.getServices()) == null || candidates.isEmpty()) {
            throw new IllegalStateException("cannot locate service " + serviceName + ", no matching service profile found");
        }
        Collections.sort(candidates, (Comparator)new Comparator<ServiceRunningInstance<T>>(){

            @Override
            public int compare(ServiceRunningInstance<T> o1, ServiceRunningInstance<T> o2) {
                try {
                    Integer u1Score = DynamicServiceLocator.this.computeScore(new URL(o1.getUrl()));
                    Integer u2Score = DynamicServiceLocator.this.computeScore(new URL(o2.getUrl()));
                    return -u1Score.compareTo(u2Score);
                }
                catch (MalformedURLException e) {
                    log.warn((Object)"ignoring service with malformed url", (Throwable)e);
                    return 0;
                }
            }
        });
        log.debug(candidates);
        return (T)this.serviceResolver.getService(this.clazz, candidates.get(0).getEpr());
    }

    protected int computeScore(URL url) throws MalformedURLException {
        return this.scorer.score(url);
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    @Required
    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public ServiceLocator<ISLookUpService> getLookUpLocator() {
        return this.lookUpLocator;
    }

    @Required
    public void setLookUpLocator(ServiceLocator<ISLookUpService> lookUpLocator) {
        this.lookUpLocator = lookUpLocator;
    }

    public ServiceNameResolver getServiceNameResolver() {
        return this.serviceNameResolver;
    }

    public void setServiceNameResolver(ServiceNameResolver serviceNameResolver) {
        this.serviceNameResolver = serviceNameResolver;
    }

    public StandaloneCxfEndpointReferenceBuilder getEprBuilder() {
        return this.eprBuilder;
    }

    public void setEprBuilder(StandaloneCxfEndpointReferenceBuilder eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    @Required
    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public DynamicServiceLocatorLocationScorer getScorer() {
        return this.scorer;
    }

    public void setScorer(DynamicServiceLocatorLocationScorer scorer) {
        this.scorer = scorer;
    }
}

