/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.store;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.schema.OpaqueResourceValidator;
import eu.dnetlib.enabling.is.registry.schema.ValidationException;
import eu.dnetlib.enabling.is.store.rmi.ISStoreException;
import eu.dnetlib.enabling.is.store.rmi.ISStoreService;
import eu.dnetlib.enabling.tools.OpaqueResource;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.XQueryUtils;
import org.springframework.beans.factory.annotation.Required;

public class BulkResourceImporter {
    private XQueryUtils xqueryUtils;
    private ServiceLocator<ISStoreService> storeLocator;
    private OpaqueResourceValidator resourceValidator;
    private boolean validating = true;
    private boolean enabled = true;

    public void importResource(OpaqueResource resource) throws ISRegistryException {
        try {
            if (this.validating) {
                this.resourceValidator.validate(resource);
            }
            this.storeLocator.getService().insertXML(this.xqueryUtils.getFileName(resource), this.xqueryUtils.getCollectionAbsPath(resource), resource.asString());
        }
        catch (ISStoreException e) {
            throw new ISRegistryException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new ISRegistryException((Throwable)e);
        }
    }

    public XQueryUtils getXqueryUtils() {
        return this.xqueryUtils;
    }

    @Required
    public void setXqueryUtils(XQueryUtils xqueryUtils) {
        this.xqueryUtils = xqueryUtils;
    }

    public ServiceLocator<ISStoreService> getStoreLocator() {
        return this.storeLocator;
    }

    @Required
    public void setStoreLocator(ServiceLocator<ISStoreService> storeLocator) {
        this.storeLocator = storeLocator;
    }

    @Required
    public void setResourceValidator(OpaqueResourceValidator resourceValidator) {
        this.resourceValidator = resourceValidator;
    }

    public OpaqueResourceValidator getResourceValidator() {
        return this.resourceValidator;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

