/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.is.store;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.is.store.BulkResourceImporter;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.StreamOpaqueResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.xml.sax.SAXException;

public class AbstractContentInitializer {
    private static final Log log = LogFactory.getLog(AbstractContentInitializer.class);
    private ServiceLocator<ISRegistryService> registryLocator;
    private BulkResourceImporter bulkImporter;

    protected void registerSchema(URL url) throws IOException, ISRegistryException {
        String resourceType = FilenameUtils.getBaseName((String)url.getPath());
        log.debug((Object)("registering schema: " + resourceType));
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)url.openStream(), (Writer)writer);
        ISRegistryService service = null;
        try {
            service = this.registryLocator.getService();
            service.addResourceType(resourceType, writer.getBuffer().toString());
        }
        catch (Exception e) {
            try {
                Thread.sleep(4000L);
                service = this.registryLocator.getService();
                service.addResourceType(resourceType, writer.getBuffer().toString());
                log.fatal((Object)("\n\n\n\n ------------->\n After sleep service is " + service));
            }
            catch (InterruptedException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    protected void registerProfile(URL url) throws IOException, ISRegistryException, XPathExpressionException, SAXException, ParserConfigurationException {
        log.debug((Object)("registering profile: " + url));
        this.bulkImporter.importResource(new StreamOpaqueResource(url.openStream()));
    }

    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setBulkImporter(BulkResourceImporter bulkImporter) {
        this.bulkImporter = bulkImporter;
    }

    public BulkResourceImporter getBulkImporter() {
        return this.bulkImporter;
    }
}

