package eu.dnetlib.enabling.manager.msro.rmi;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ProcessDescription implements Comparable<ProcessDescription> {

	private String processId;
	private String workflowName;
	private ProcessStatus status;
	private String lastActivity;
	private ProcessCompletionStatus completionStatus;

	public ProcessDescription() {
	}

	public ProcessDescription(final String processId, final String workflowName, final ProcessStatus status, final String lastActivity) {
		super();
		this.processId = processId;
		this.workflowName = workflowName;
		this.status = status;
		this.lastActivity = lastActivity;
	}

	public String getProcessId() {
		return processId;
	}
	public void setProcessId(final String processId) {
		this.processId = processId;
	}
	public String getWorkflowName() {
		return workflowName;
	}
	public void setWorkflowName(final String workflowName) {
		this.workflowName = workflowName;
	}
	public ProcessStatus getStatus() {
		return status;
	}
	public void setStatus(final ProcessStatus status) {
		this.status = status;
	}

	public String getLastActivity() {
		return lastActivity;
	}

	public void setLastActivity(final String lastActivity) {
		this.lastActivity = lastActivity;
	}

	protected Date getLatestActivityDate() {
		final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); // NOPMD;
		try {
			return sdf.parse(getLastActivity());
		} catch (final ParseException e) {
			return null;
		}
	}

	@Override
	public int compareTo(final ProcessDescription other) {
		Date thisDate = getLatestActivityDate();
		Date otherDate = other.getLatestActivityDate();
		if (thisDate == null)
			thisDate = new Date(0);

		if (otherDate == null)
			otherDate = new Date(0);

		return -thisDate.compareTo(otherDate);
	}

	public ProcessCompletionStatus getCompletionStatus() {
		return completionStatus;
	}

	public void setCompletionStatus(final ProcessCompletionStatus completionStatus) {
		this.completionStatus = completionStatus;
	}
}
