package eu.dnetlib.data.mdstore;

import java.util.List;

import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import eu.dnetlib.common.rmi.BaseService;

@WebService
public interface MDStoreService extends BaseService {

	/**
	 * Identifies service and version.
	 * @return
	 */
	public String identify();
	
	/**
	 * Returns ResultSet EPR for delivered mdstore records.
	 * @param mdFormat
	 * @param from
	 * @param until
	 * @throws MDStoreServiceException
	 * @return ResultSet EPR 
	 */
	public W3CEndpointReference deliverMDRecords(
			@WebParam(name="mdId") String mdId, 
			@WebParam(name="from") String from,
			@WebParam(name="until") String until,
			@WebParam(name="recordsFilter") String recordFilter)
		throws MDStoreServiceException;
	
	/**
	 * Deliver single record from selected mdstore.
	 * @param mdId
	 * @param recordId
	 * @throws MDStoreServiceException
	 * @return record 
	 */
	public String deliverRecord(
			@WebParam(name="mdId") String mdId, 
			@WebParam(name="recordId") String recordId)
		throws MDStoreServiceException;
	
	/**
	 * Returns list of all stored indices.
	 * @return list of all stored indices
	 */
	public List<String> getListOfMDStores();
	
	public List<String> listMDStores(
			@WebParam(name = "format") String format, 
			@WebParam(name = "layout") String layout, 
			@WebParam(name = "interpretation") String interpretation);
	
	public W3CEndpointReference bulkDeliverMDRecords(
			@WebParam(name = "format") String format, 
			@WebParam(name = "layout") String layout, 
			@WebParam(name = "interpretation") String interpretation);
	
	/**
	 * Store md records from a result set
	 * @param mdId
	 * @param rsId
	 * @param storingType
	 * @throws MDStoreServiceException
	 * @return Statistics
	 */
	public boolean storeMDRecordsFromRS(
			@WebParam(name="mdId") String mdId, 
			@WebParam(name="rsId") String rsId,
			@WebParam(name="storingType") String storingType);	
}
