package eu.dnetlib.data.information.publisher.rmi;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import eu.dnetlib.common.rmi.BaseService;

/**
 * Publisher service. Provides access to metadata records and objects.
 *
 * @author marko
 *
 */
@WebService
public interface PublisherService extends BaseService {
	/**
	 * Get a (metadata) resource by ID.
	 *
	 * @param id
	 *            record identifier
	 * @param format
	 *            record format
	 * @return record or null
	 */
	@WebMethod
	String getResourceById(@WebParam(name = "id") String id, @WebParam(name = "format") String format);

	/**
	 * Get (metadata) resources by IDs.
	 *
	 * @param ids list of ids
	 * @param format record format
	 * @return resultset
	 */
	@WebMethod
	W3CEndpointReference getResourcesByIds(@WebParam(name = "ids") List<String> ids, @WebParam(name = "format") String format);
}
