/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.rmi;

import eu.dnetlib.enabling.manager.msro.rmi.ProcessCompletionStatus;
import eu.dnetlib.enabling.manager.msro.rmi.ProcessStatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ProcessDescription
implements Comparable<ProcessDescription> {
    private String processId;
    private String workflowName;
    private ProcessStatus status;
    private String lastActivity;
    private ProcessCompletionStatus completionStatus;

    public ProcessDescription() {
    }

    public ProcessDescription(String processId, String workflowName, ProcessStatus status, String lastActivity) {
        this.processId = processId;
        this.workflowName = workflowName;
        this.status = status;
        this.lastActivity = lastActivity;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcessStatus status) {
        this.status = status;
    }

    public String getLastActivity() {
        return this.lastActivity;
    }

    public void setLastActivity(String lastActivity) {
        this.lastActivity = lastActivity;
    }

    protected Date getLatestActivityDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(this.getLastActivity());
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public int compareTo(ProcessDescription other) {
        Date thisDate = this.getLatestActivityDate();
        Date otherDate = other.getLatestActivityDate();
        if (thisDate == null) {
            thisDate = new Date(0L);
        }
        if (otherDate == null) {
            otherDate = new Date(0L);
        }
        return -thisDate.compareTo(otherDate);
    }

    public ProcessCompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public void setCompletionStatus(ProcessCompletionStatus completionStatus) {
        this.completionStatus = completionStatus;
    }
}

