<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="xsl">

	<xsl:template match="/">
		<RESOURCE_PROFILE>
	    	<HEADER>
		        <RESOURCE_IDENTIFIER value=""/>
		        <RESOURCE_TYPE value="VocabularyDSResourceType"/>
		        <RESOURCE_KIND value="VocabularyDSResources"/>
		        <RESOURCE_URI value=""/>
		        <DATE_OF_CREATION value=""/>
	    	</HEADER>
	    	<BODY>
		        <CONFIGURATION>
		            <VOCABULARY_NAME><xsl:value-of select="//FIELD[@name='name']" /></VOCABULARY_NAME>
		            <VOCABULARY_DESCRIPTION><xsl:value-of select="//FIELD[@name='description']" /></VOCABULARY_DESCRIPTION>
		            <TERMS>
		            	<xsl:for-each select="//FIELD[@name='terms']/ITEM">
							<xsl:variable name="termCode" select="substring-before(., '@@@')" />
							<xsl:variable name="termName" select="substring-after(., '@@@')" />
							<TERM native_name="{$termName}" english_name="{$termName}" encoding="{$termCode}">
			                    <SYNONYMS />
							</TERM>
						</xsl:for-each>
					</TERMS>
				</CONFIGURATION>
				<STATUS>
	            	<LAST_UPDATE value="{//FIELD[@name='now']}"/>
	        	</STATUS>
	        	<SECURITY_PARAMETERS>String</SECURITY_PARAMETERS>
			</BODY>
		</RESOURCE_PROFILE>
	</xsl:template>
</xsl:stylesheet>