SELECT 
	s.code                                    AS name,
	s.name                                    AS description,
	array_agg(DISTINCT c.code||'@@@'||c.name) AS terms,
	to_char(now(), 'YYYY-MM-DDThh24:mi:ssZ')  AS now
FROM
	scheme s 
	LEFT OUTER JOIN class_scheme cs ON (s.code = cs.scheme) 
	LEFT OUTER JOIN class c ON (cs.class = c.code)
GROUP BY 
	s.code, s.name