SELECT 
	d.id,
	d.officialname,	
	d.englishname,
	d.websiteurl,
	d.logourl,
	d.contactemail,
	d.namespaceprefix,         	
	d.od_numberofitems,
	d.latitude,
	d.longitude,
	d.timezone,
	d.collectedfrom,
	d.openairecompatibilityclass,
	d.openairecompatibilityscheme,
	d.optional1,
	d.optional2,
	d.datasourceclass,
	d.dateofvalidation,
	d.dateofcollection,
	d.typology,
	d.activationid,
	d.mergehomonyms,
	d.aggregator,
	(array_agg(o.legalname))[1] as organization,
	o.countryclass  as country,
	array_agg(ag.accessinfopackage) as accessinfopackage,
	to_char(now(), 'YYYY-MM-DDThh24:mi:ssZ') AS now
	
FROM datasources d
	LEFT OUTER JOIN datasource_organization dso ON d.id = dso.datasource
	LEFT OUTER JOIN organizations o ON dso.organization = o.id
	LEFT OUTER JOIN (
			SELECT 	api.datasource,
					CASE WHEN api.useedited=true 
						THEN api.typology||'==='||api.edited||'###'|| api.editedprotocolclass||'@@@'||array_to_string(array_agg(ac.accessparam||'='||ac.accessvalue), '***') 
						ELSE api.typology||'==='||api.original||'###'|| api.originalprotocolclass||'@@@'||array_to_string(array_agg(ac.accessparam||'='||ac.accessvalue), '***') 
					END as accessinfopackage
			FROM api 
			LEFT OUTER JOIN apicollections ac ON (ac.api = api.id) 
			GROUP BY 
				api.datasource,
				api.typology,
				api.useedited,
				api.original,
				api.originalprotocolclass,
				api.edited,
				api.editedprotocolclass
		) as ag on (ag.datasource = d.id)

WHERE 
	openairecompatibilityclass IS NOT null
	AND openairecompatibilityclass != 'UNKNOWN'
	AND openairecompatibilityclass != 'notCompatible'
	AND datasourceclass != 'entityregistry'

GROUP BY
		d.id,
		d.officialname, 
		d.englishname,
		d.websiteurl,
		d.logourl,
		d.contactemail,
		d.namespaceprefix,
		d.od_numberofitems,
		d.latitude,
		d.longitude,
		d.timezone,
		d.collectedfrom,
		d.openairecompatibilityclass,
		d.openairecompatibilityscheme,
		d.optional1,
		d.optional2,
		d.datasourceclass,
		d.dateofvalidation,
		d.dateofcollection,
		d.typology,
		d.activationid,
		d.mergehomonyms,
		d.aggregator,
		o.countryclass

