<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri" 
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DNetDbToHbaseXsltFunctions">
	
	<xsl:output omit-xml-declaration="yes" indent="yes"/>

	<xsl:template match="/">
		
		<xsl:variable name="originalId" select="//FIELD[@name = 'resultid']" />
		<xsl:variable name="tmpId">
			<xsl:choose>
				<xsl:when test="//FIELD[@name = 'access_mode'] = 'OPEN'">
					<xsl:value-of select="concat('OPENAIRE_000::', $originalId)" />		
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('OPENAIRE_111::', $originalId)" />		
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		 
		<xsl:variable name="resultId" select="dnet:oafSplitId('result', normalize-space($tmpId))" />

		<ROWS>
			<ROW key="{$resultId}" columnFamily="result">
				<QUALIFIER name="body" type="base64"><xsl:value-of select="dnet:oafEntity('result', $resultId, 'TEST', 'TEST', $originalId, '2013-01-01', //FIELD[not(@isNull)])"/></QUALIFIER>
			</ROW>
		</ROWS>
		
	</xsl:template>

</xsl:stylesheet>
