<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri" 
	xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
	xmlns:dnet="eu.dnetlib.data.transform.xml.DNetDbToHbaseXsltFunctions">
	
	<xsl:output omit-xml-declaration="yes" indent="yes"/>

	<xsl:template match="/">

		<xsl:variable name="originalid" select="//FIELD[@name = 'datasourceid']" />
		<xsl:variable name="datasourceid" select="dnet:oafSplitId('datasource', $originalid)" />		
		<xsl:variable name="dateofcollection" select="//FIELD[@name = 'dateofcollection']" />
		<xsl:variable name="collectedfromid" select="dnet:oafSplitId('datasource', //FIELD[@name = 'collectedfromid'])" />
		<xsl:variable name="collectedfromname" select="//FIELD[@name = 'collectedfromname']" />
		
		<ROWS>
			<xsl:if test="string-length($datasourceid) &gt; 0">
			
				<xsl:variable name="datasource" select="dnet:oafEntity('datasource', $datasourceid, $collectedfromid, $collectedfromname, $originalid, $dateofcollection, //FIELD[not(@isNull)])"/>

				<ROW key="{$datasourceid}" columnFamily="datasource">
					<QUALIFIER name="body" type="base64"><xsl:value-of select="$datasource"/></QUALIFIER>
				</ROW>
			</xsl:if>
		</ROWS>
	
	</xsl:template>

</xsl:stylesheet>
