<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
	xmlns:oai="http://www.openarchives.org/OAI/2.0/" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dri="http://www.driver-repository.eu/namespace/dri"
	xmlns:feedhelper="eu.dnetlib.enabling.manager.msro.openaire.FeedHelper"
	exclude-result-prefixes="xsl datetime exslt xsi feedhelper">

	<!-- identity transformation -->

	<xsl:output method="xml" indent="yes" />

	<xsl:variable name="dataSourceId" select="feedhelper:getOpenDoarId(substring(//dri:repositoryId, 1, 200))" />
	
	<xsl:template match="oai_dc:dc">
		<xsl:copy>
		
			<xsl:for-each select="//dc:relation">
				<oaf:projectid><xsl:value-of select="substring(normalize-space(.), 36, 200)"/></oaf:projectid>
			</xsl:for-each>

			<oaf:datasourceid><xsl:value-of select="$dataSourceId"/></oaf:datasourceid>

			<xsl:apply-templates select="@*|*|text()" />
		</xsl:copy>
	</xsl:template>


	<xsl:template match="@*|*">
		<xsl:copy>
			<xsl:apply-templates select="@*|*|text()" />
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>
