<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:dr="http://www.driver-repository.eu/namespace/dr" xmlns:dri="http://www.driver-repository.eu/namespace/dri" 
    xmlns:oaa="http://namespace.openaire.eu/oaa" xmlns:oaf="http://namespace.openaire.eu/oaf"
    xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:dnet="eu.dnetlib.data.transform.xml.DNetMdStoreToHbaseXsltFunctions"> 
    
    <xsl:param name="parentDatasourceId" />
    <xsl:param name="namespacePrefix" />
    
    <xsl:template match="/">
        
        <xsl:variable name="accessInfoPackage" select="//rOaiBaseUrl" />
<!--         <xsl:choose> -->
<!--             <xsl:when test="string-length($accessInfoPackage) = 0"> -->
<!--                 <ROWS/> -->
<!--             </xsl:when> -->
<!--             <xsl:otherwise> -->
            
               <xsl:variable name="rid" select="//repository/@rID" />
               <xsl:variable name="datasourceId" select="concat($namespacePrefix, '::', $rid)" />
               <xsl:variable name="oUrl" select="//oUrl" />
               <xsl:variable name="oName" select="//oName" />
               <xsl:variable name="organizationId" select="translate(concat($namespacePrefix, '::', $oName), ' ', '_')" />
               
               <xsl:variable name="contenttypes">
                   <xsl:for-each select=".//contentType">
                       <xsl:if test="position() &gt; 1"> - </xsl:if>
                       <xsl:value-of select="."/>
                   </xsl:for-each>
               </xsl:variable>
               <xsl:variable name="languages">
                   <xsl:for-each select=".//lName">
                       <xsl:if test="position() &gt; 1">, </xsl:if>
                       <xsl:value-of select="."/>
                   </xsl:for-each>
               </xsl:variable>
<!--                <xsl:variable name="subjects"> -->
<!--                    <xsl:for-each select=".//clTitle"> -->
<!--                        <xsl:if test="position() &gt; 1">, </xsl:if> -->
<!--                        <xsl:value-of select="."/> -->
<!--                    </xsl:for-each> -->
<!--                </xsl:variable> -->
               
               <ROWS>
                   <ROW table="datasources">
                       <FIELD name="id"><xsl:value-of select="$datasourceId" /></FIELD>
                       <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$datasourceId" /></FIELD> 
                       
                       <FIELD name="officialname"><xsl:value-of select="//rName" /></FIELD>
                       <FIELD name="englishname"><xsl:value-of select="//rAcronym" /></FIELD>
                       <FIELD name="od_contenttypes"><xsl:value-of select="normalize-space($contenttypes)" /></FIELD>

                       <FIELD name="od_languages"><xsl:value-of select="normalize-space($languages)" /></FIELD>
                       <FIELD name="od_numberofitems"><xsl:value-of select="//rNumOfItems" /></FIELD>
                       <FIELD name="od_numberofitemsdate"><xsl:value-of select="//rDateHarvested" /></FIELD>
                       <FIELD name="description"><xsl:value-of select="normalize-space(//rDescription)" /></FIELD>

                       <!-- 				<FIELD name="od_policies"><xsl:value-of select="normalize-space($policies)" /></FIELD> -->
                       <FIELD name="contactEmail"><xsl:value-of select="//pEmail" /></FIELD>
                       <FIELD name="latitude" type="float"><xsl:value-of select="//paLatitude" /></FIELD>
                       <FIELD name="longitude" type="float"><xsl:value-of select="//paLongitude" /></FIELD>
                       <FIELD name="websiteurl"><xsl:value-of select="//rUrl" /></FIELD>
<!--                   <FIELD name="accessinfopackage"><xsl:value-of select="$accessInfoPackage" /></FIELD> -->
                       <FIELD name="logourl"></FIELD>
                       <FIELD name="namespaceprefix"><xsl:value-of select="dnet:generateNsPrefix('od', $rid)"/></FIELD>
                       <FIELD name="datasourceclass">pubsrepository::unknown</FIELD>
                       <FIELD name="datasourcescheme">dnet:datasource_typologies</FIELD>
                       <FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
                       <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
                       <FIELD name="typology"><xsl:value-of select="//rSoftWareName" /></FIELD>
                       <FIELD name="optional1"></FIELD>
                       <FIELD name="optional2"></FIELD>
                       <FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
                   </ROW>
                   
                   <xsl:for-each select=".//class">
                   		<xsl:variable name="subjectId" select="normalize-space(concat($parentDatasourceId, '::', ./clCode))"/>
                   		<xsl:variable name="subjectValue" select="normalize-space(./clTitle)"/>
						<ROW table="subjects">
						   <FIELD name="id"><xsl:value-of select="$subjectId" /></FIELD>
						   <FIELD name="name"><xsl:value-of select="$subjectValue" /></FIELD>   
	                       <FIELD name="semanticclass">dnet:od_subjects</FIELD>  
	                       <FIELD name="semanticscheme">dnet:subject_classification_typologies</FIELD>  
	                       <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$subjectId" /></FIELD>
	                 	</ROW>
						<ROW table="datasource_subject">
						   <FIELD name="datasource"><xsl:value-of select="$datasourceId" /></FIELD>
						   <FIELD name="subject"><xsl:value-of select="$subjectId" /></FIELD>   
	                       <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($datasourceId, '@@', $subjectId)" /></FIELD>
	                 	</ROW>
                   </xsl:for-each>                   
					
					<xsl:variable name="apiId" select="concat('api_________::', $datasourceId, '::0')" />
					<ROW table="api">
					   <FIELD name="id"><xsl:value-of select="$apiId" /></FIELD>
                       <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$apiId" /></FIELD>
                       <FIELD name="originalprotocolclass">oai</FIELD>
                       <FIELD name="original"><xsl:value-of select="$accessInfoPackage" /></FIELD>
                       <FIELD name="datasource"><xsl:value-of select="$datasourceId" /></FIELD>
                 	</ROW>

					<ROW table="apicollections">
					   <FIELD name="api"><xsl:value-of select="$apiId" /></FIELD>
                       <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat('FORMAT@@oai_dc@@', $apiId)" /></FIELD>
                       <FIELD name="accessparam">FORMAT</FIELD>
                       <FIELD name="accessvalue">oai_dc</FIELD>
                 	</ROW>
                 	
<!-- 					<ROW table="apicollections"> -->
<!-- 					   <FIELD name="api"><xsl:value-of select="$apiId" /></FIELD> -->
<!--                        <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat('SET@@ec_fundedresources@@', $apiId)" /></FIELD> -->
<!--                        <FIELD name="accessparam">SET</FIELD> -->
<!--                        <FIELD name="accessvalue">ec_fundedresources</FIELD> -->
<!--                  	</ROW> -->
                   
                   <ROW table="organizations">
                       <FIELD name="id"><xsl:value-of select="$organizationId" /></FIELD>
                       <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$organizationId" /></FIELD>
                       <FIELD name="legalname"><xsl:value-of select="$oName" /></FIELD>
                       <FIELD name="legalshortname"><xsl:value-of select="//oAcronym" /></FIELD>
                       <FIELD name="websiteurl"><xsl:value-of select="//oUrl" /></FIELD>
                       
                       <!-- 				<FIELD name="ec_legalbody">false</FIELD> -->
                       <!-- 				<FIELD name="ec_legalperson">false</FIELD> -->
                       <!-- 				<FIELD name="ec_nonprofit">false</FIELD> -->
                       <!-- 				<FIELD name="ec_researchOrganization">false</FIELD>	-->
                       <!-- 				<FIELD name="ec_higherEducation">false</FIELD> -->
                       <!-- 				<FIELD name="ec_internationalOrganizationEurInterests">false</FIELD> -->
                       <!-- 				<FIELD name="ec_internationalOrganization">false</FIELD> -->
                       <!-- 				<FIELD name="ec_enterprise">false</FIELD> -->
                       <!-- 				<FIELD name="ec_SMEValidated">false</FIELD> -->
                       <!-- 				<FIELD name="ec_NUTScode">false</FIELD> -->
                       
                       <FIELD name="countryClass">
                           <xsl:choose>
                               <xsl:when test="normalize-space(//cIsoCode) = 'GB'">UK</xsl:when>
                               <xsl:otherwise><xsl:value-of select="normalize-space(//cIsoCode)"></xsl:value-of></xsl:otherwise>
                           </xsl:choose>
                       </FIELD>
                       <FIELD name="countryScheme">dnet:countries</FIELD>
                       
                       <FIELD name="collectedfrom"><xsl:value-of select="$parentDatasourceId" /></FIELD>
                       <!-- 				<FIELD name="provenance_kind">OpenDOAR</FIELD> -->
                       <!-- 				<FIELD name="provenance_context"><xsl:value-of select="$datasourceId" /></FIELD> -->
                       
                       <FIELD name="provenanceActionClass">sysimport:crosswalk:entityregistry</FIELD>
                       <FIELD name="provenanceActionScheme">dnet:provenanceActions</FIELD>
                       <FIELD name="trust" type="float">0.8</FIELD>
                       
                   </ROW>
                   
                   <ROW table="datasource_organization">
                       <FIELD name="datasource"><xsl:value-of select="$datasourceId" /></FIELD>
                       <FIELD name="organization"><xsl:value-of select="$organizationId" /></FIELD>
                       <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="concat($datasourceId,'@@',$organizationId)" /></FIELD>
                   </ROW>
                   
               </ROWS>
<!--             </xsl:otherwise> -->
<!--         </xsl:choose> -->
    </xsl:template>
    
</xsl:stylesheet>
