<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:dr="http://www.driver-repository.eu/namespace/dr"	xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa"
	xmlns:oaf="http://namespace.openaire.eu/oaf">

	<xsl:template match="/*">

		<xsl:choose>
			<xsl:when test="count(./*) = 0">
				<ROWS/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="country" select="substring(//dr:repositoryCountry,  1, 200)" />
				<xsl:variable name="resultId" select="substring(//dri:objIdentifier,    1, 200)" />
				<xsl:variable name="repositoryId" select="substring(//oaf:datasourceid, 1, 200)" />
				<xsl:variable name="accessmode" select="substring(//oaf:accessrights,   1, 200)" />
				
				<ROWS>
					<ROW table="results">
						<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$resultId" /></FIELD>
						<FIELD name="resultid"><xsl:value-of select="$resultId" /></FIELD>
						<FIELD name="description"><xsl:value-of select="substring(//dc:description,1,3000)" /></FIELD>
						<!-- <FIELD name="embargo_end_date"></FIELD> -->
						<FIELD name="keywords"><xsl:value-of select="substring(//dc:subject,1,200)" /></FIELD>
						<FIELD name="language"><xsl:value-of select="substring(//dc:language,1,200)" /></FIELD>
						
						<FIELD name="publication_date" type="date"><xsl:value-of select="//dc:dateAccepted" /></FIELD>
						
						<FIELD name="publisher"><xsl:value-of select="substring(//dc:publisher,1,200)" /></FIELD>
						<!-- <FIELD name="subjects"><xsl:value-of select="substring(//dc:subject, 1, 200)" /></FIELD> -->
						<FIELD name="title"><xsl:value-of select="substring(//dc:title,1,200)" /></FIELD>
						<FIELD name="haskind">Publication</FIELD>
						<FIELD name="hastype"><xsl:value-of select="substring(//dr:CobjCategory,1,200)" /></FIELD>
						<FIELD name="access_mode"><xsl:value-of select="$accessmode" /></FIELD>
						<FIELD name="createdfrom">harvest</FIELD>
						<xsl:if test="//*[local-name()='header']/@status='deleted'">
							<FIELD name="pmhdeleted" type="boolean">true</FIELD>
						</xsl:if> 
					</ROW>
				
					<xsl:variable name="instanceId" select="concat($resultId, ':', $repositoryId)" /> 
					<xsl:variable name="collectedFrom" select="//oaf:collectedDatasourceid" />
					<xsl:variable name="hostedby" select="//oaf:hostingDatasourceid" />
				
					<ROW table="instances">
						<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$instanceId" /></FIELD>
						<FIELD name="instanceid"><xsl:value-of select="$instanceId" /></FIELD>
						<FIELD name="resource"><xsl:value-of select="$resultId" /></FIELD>
						<FIELD name="hostedby"><xsl:value-of select="$hostedby" /></FIELD>
						<FIELD name="collectedfrom"><xsl:value-of select="$collectedFrom" /></FIELD>
					</ROW>
					
					<xsl:for-each select="//dc:identifier">
					<xsl:if test="starts-with(normalize-space(.), 'http:')">
					  <xsl:variable name="webResourceId" select="concat($resultId, ':', $repositoryId, ':', position())" /> 
					
					  <ROW table="webresources">
						  <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$webResourceId" /></FIELD>
					    <FIELD name="webresourceid"><xsl:value-of select="$webResourceId" /></FIELD>
					  	<FIELD name="file_url"><xsl:value-of select="." /></FIELD>
					  </ROW>
					
					  <ROW table="webresources_instances">
					    <!-- we have only one webResource per instance for now -->
						  <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$webResourceId" /></FIELD>
					    <FIELD name="webresourceid"><xsl:value-of select="$webResourceId" /></FIELD>
					    <FIELD name="instanceid"><xsl:value-of select="$instanceId" /></FIELD>
					  </ROW>
					</xsl:if>
					</xsl:for-each>
					
					<xsl:for-each select="//oaf:projectid">
						<xsl:variable name="projectId" select="substring(normalize-space(.), 1, 200)" />
						<xsl:variable name="rpId" select="concat($resultId, ':', $projectId)" /> 
						<ROW table="results_projects">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$rpId" /></FIELD>
							<FIELD name="result"><xsl:value-of select="$resultId" /></FIELD>
							<FIELD name="project"><xsl:value-of select="$projectId" /></FIELD>
						</ROW>
					</xsl:for-each>
				
					<xsl:for-each select="//dc:creator">
						<xsl:variable name="authorShipId" select="concat($resultId, '_', translate(.,' ','_'))" /> 
						<xsl:variable name="authorId" select="$authorShipId" /> 
						
						<ROW table="persons">
							<!-- TODO review this table -->
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$authorId" /></FIELD>
							<FIELD name="personid"><xsl:value-of select="$authorId" /></FIELD>
							<FIELD name="name"><xsl:value-of select="." /></FIELD>
							<FIELD name="surname">UNKNOWN</FIELD>
							<FIELD name="provenance_kind">Repository</FIELD>
							<FIELD name="provenance_context"><xsl:value-of select="$resultId" /></FIELD>
		<!--					<FIELD name="nationality"><xsl:value-of select="$country" /></FIELD>-->
						</ROW>
						
						<ROW table="authorships">
							<FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$authorShipId" /></FIELD>
							<FIELD name="authorshipid"><xsl:value-of select="$authorShipId" /></FIELD>
		<!--					<FIELD name="email">unknown@noreplay.com</FIELD>-->
							<FIELD name="result"><xsl:value-of select="$resultId" /></FIELD>
							<FIELD name="author"><xsl:value-of select="$authorId" /></FIELD>
							<FIELD name="rank" type="int"><xsl:value-of select="position()" /></FIELD>
						</ROW>
					</xsl:for-each>
				</ROWS>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
