/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.objectstore;

import eu.dnetlib.enabling.manager.msro.openaire.objectstore.LinkedObject;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLGenerator
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(URLGenerator.class);
    private Iterator<String> records = null;
    private LinkedObject currentObject = null;
    XMLInputFactory factory;
    final String dcNamespace = "http://purl.org/dc/elements/1.1/";

    public void generateURLs(W3CEndpointReference epr, ResultSetClientFactory resultSetClientFactory) {
        this.records = resultSetClientFactory.getClient(epr).iterator();
        if (this.factory == null) {
            this.factory = XMLInputFactory.newInstance();
        }
    }

    private LinkedObject getIdentifiers(String record) {
        LinkedObject o = new LinkedObject();
        try {
            XMLStreamReader parser = this.factory.createXMLStreamReader(new ByteArrayInputStream(record.getBytes()));
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                String name = parser.getLocalName();
                if ("identifier".equals(name)) {
                    String namespace = parser.getName().getNamespaceURI();
                    if (namespace != null) {
                        namespace = namespace.trim();
                    }
                    if (!"http://purl.org/dc/elements/1.1/".equals(namespace)) continue;
                    parser.next();
                    o.addURL(parser.getText().trim());
                    continue;
                }
                if (!"objIdentifier".equals(name)) continue;
                parser.next();
                o.setObjectIdentifier(parser.getText().trim());
            }
        }
        catch (XMLStreamException e) {
            log.error((Object)"Got exception in getIdentifiers  ", (Throwable)e);
            return null;
        }
        if (o.getObjectIdentifier() != null && o.getURLS() != null && o.getURLS().size() > 0) {
            return o;
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){

            @Override
            public void remove() {
            }

            @Override
            public String next() {
                String out = URLGenerator.this.currentObject.toJSON();
                URLGenerator.this.currentObject = null;
                return out;
            }

            @Override
            public boolean hasNext() {
                if (URLGenerator.this.records == null) {
                    return false;
                }
                if (URLGenerator.this.currentObject == null) {
                    if (!URLGenerator.this.records.hasNext()) {
                        return false;
                    }
                    URLGenerator.this.currentObject = URLGenerator.this.getNextObject();
                    return URLGenerator.this.currentObject != null;
                }
                return true;
            }
        };
    }

    private LinkedObject getNextObject() {
        LinkedObject tmp = null;
        while (this.records.hasNext()) {
            String nextRecord = this.records.next();
            tmp = this.getIdentifiers(nextRecord);
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }
}

