/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.objectstore;

import gr.uoa.di.resourcediscovery.MethodProvider;
import gr.uoa.di.resourcediscovery.MethodProviderFileStorageImpl;
import gr.uoa.di.resourcediscovery.methods.ResourceDiscoveryMethod;
import gr.uoa.di.resourcediscovery.methods.XPathAndCrawl;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URLExtractor {
    private static final Log log = LogFactory.getLog(URLExtractor.class);
    private String methodMapFileStorageDir = "/tmp/";
    private MethodProvider provider;
    protected List<String> mimeTypes = Arrays.asList("application/pdf");

    public URLExtractor() throws FileNotFoundException {
        String fileName = this.methodMapFileStorageDir;
        if (!this.methodMapFileStorageDir.endsWith(File.separator)) {
            fileName = fileName + File.separator;
        }
        fileName = fileName + "method-map.xml";
        this.provider = new MethodProviderFileStorageImpl(fileName);
    }

    public String provideContent(String contentLocation) {
        try {
            List resources;
            URL conUrl = new URL(contentLocation);
            ResourceDiscoveryMethod method = this.provider.getMethod(conUrl);
            if (method == null) {
                XPathAndCrawl xpath = new XPathAndCrawl(this.mimeTypes, null);
                method = xpath;
            }
            if ((resources = method.getResources(conUrl, this.provider)).size() > 1) {
                return (String)resources.get(0);
            }
        }
        catch (Exception e) {
            log.error((Object)"unable to obtain resource from location ", (Throwable)e);
            return null;
        }
        return null;
    }

    public String getMethodMapFileStorageDir() {
        return this.methodMapFileStorageDir;
    }

    public void setMethodMapFileStorageDir(String methodMapFileStorageDir) {
        this.methodMapFileStorageDir = methodMapFileStorageDir;
    }
}

