/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.objectstore;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.DataSinkSourceException;
import eu.dnetlib.data.information.DataSource;
import eu.dnetlib.data.information.DataSourceResolver;
import eu.dnetlib.enabling.manager.msro.openaire.objectstore.URLGenerator;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetreiveURLS
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(RetreiveURLS.class);
    @Resource(name="dataSourceResolver")
    private DataSourceResolver resolver;
    @Resource(name="objectStoreiterableResultSetFactory")
    private IterableResultSetFactory resultSetFactory;
    private ResultSetClientFactory resultSetClientFactory;

    public void execute(Engine engine, NodeToken token) {
        String mdStore = token.getEnv().getAttribute("mdstoreId");
        log.info((Object)("Mdsotre id is " + mdStore));
        if (mdStore != null) {
            DataSource source = this.resolver.resolve(mdStore);
            try {
                URLGenerator generator = new URLGenerator();
                W3CEndpointReference eprSource = source.retrieve();
                generator.generateURLs(eprSource, this.resultSetClientFactory);
                W3CEndpointReference eprUrls = this.resultSetFactory.createIterableResultSet((Iterable)generator);
                token.getEnv().setAttribute("epr", eprUrls.toString());
            }
            catch (DataSinkSourceException e) {
                log.error((Object)"got Excpetion on execute", (Throwable)e);
            }
        }
        super.execute(engine, token);
    }

    public DataSourceResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(DataSourceResolver resolver) {
        this.resolver = resolver;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public IterableResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public void setResultSetFactory(IterableResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }
}

