/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.objectstore;

import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.information.DataSinkResolver;
import eu.dnetlib.data.information.MDStoreDataSinkSourceDescriptorGenerator;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.wf.AbstractDataDSJobNode;
import eu.dnetlib.enabling.tools.ServiceLocator;
import javax.annotation.Resource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LDObjectStoreNode
extends AbstractDataDSJobNode {
    private static final Log log = LogFactory.getLog(LDObjectStoreNode.class);
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource(name="dataSinkResolver")
    private DataSinkResolver dataSinkResolver;
    private String inputFormat = "metadata";
    private String outputFormat = "PDF";
    private String inputInterpretation = "cleaned";
    private String outputInterpretation = "pdf-download";
    private String sinkType = "REFRESH";
    private String inputFormatAttributeName;
    private String outputFormatAttributeName;

    private String findObjectStoreURI() {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'ObjectStoreServiceResourceType']//RESOURCE_URI/@value/string()";
        try {
            log.info((Object)("QUERY " + query));
            String objectStoreURL = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query).trim();
            return objectStoreURL;
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.debug((Object)"MDStore not found");
        }
        catch (ISLookUpException e) {
            log.error((Object)"Got Exception on findObjectStoreURI", (Throwable)e);
        }
        return null;
    }

    private String findMetadataStoreCleanedByRepoId(String repoID) {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'TransformationDSResourceType'and .//SOURCE_METADATA_FORMAT/@interpretation='native' and .//SOURCE_METADATA_FORMAT/@layout='store'and .//SINK_METADATA_FORMAT/@interpretation='cleaned'and .//SINK_METADATA_FORMAT/@layout='store'and .//REPOSITORY_SERVICE_IDENTIFIER='" + repoID + "']//DATA_SINK/text()";
        try {
            log.info((Object)("QUERY " + query));
            String MDStoreCleanedId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query).trim();
            return MDStoreCleanedId;
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.debug((Object)"MDStore not found");
        }
        catch (ISLookUpException e) {
            log.error((Object)"Got Exception on findMetadataStoreCleanedByRepoId", (Throwable)e);
        }
        return null;
    }

    protected String getDSType() {
        return "lds";
    }

    protected void prepareParameters(StringTemplate template, Env env) {
        this.readInputFormatFromEnv(env);
        this.readOutputFormatFromEnv(env);
        String objectID = env.getAttribute("objectStoreId");
        String repoId = env.getAttribute("repoId");
        log.info((Object)("RepoId is " + repoId));
        log.info((Object)("ObjectStore ID is " + objectID));
        String metadataStore = this.findMetadataStoreCleanedByRepoId(repoId);
        log.info((Object)("MetadataStore ID " + metadataStore));
        template.setAttribute("input_mdFormat", (Object)this.inputFormat);
        template.setAttribute("output_mdFormat", (Object)this.outputFormat);
        template.setAttribute("input_interpretation", (Object)this.inputInterpretation);
        template.setAttribute("output_interpretation", (Object)this.outputInterpretation);
        template.setAttribute("sink_type", (Object)this.sinkType);
        MDStoreDataSinkSourceDescriptorGenerator md = new MDStoreDataSinkSourceDescriptorGenerator();
        template.setAttribute("input_mdstore_id", (Object)md.getParameters(metadataStore).getId());
        template.setAttribute("output_objectstore_id", (Object)objectID);
        template.setAttribute("repositoryId", (Object)repoId);
        env.setAttribute("objectStoreId", objectID);
        env.setAttribute("mdstoreId", metadataStore);
        String ObjectStoreURI = this.findObjectStoreURI();
        log.info((Object)("Object Store URI " + ObjectStoreURI));
        template.setAttribute("serviceId", (Object)ObjectStoreURI);
        env.setAttribute("mdStoreId", metadataStore);
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    private void readInputFormatFromEnv(Env env) {
        String inputF = env.getAttribute(this.inputFormatAttributeName);
        if (inputF != null) {
            this.inputFormat = inputF;
        }
    }

    private void readOutputFormatFromEnv(Env env) {
        String outF = env.getAttribute(this.outputFormatAttributeName);
        if (outF != null) {
            this.outputFormat = outF;
        }
    }

    public String getInputInterpretation() {
        return this.inputInterpretation;
    }

    public void setInputInterpretation(String inputInterpretation) {
        this.inputInterpretation = inputInterpretation;
    }

    public String getOutputInterpretation() {
        return this.outputInterpretation;
    }

    public void setOutputInterpretation(String outputInterpretation) {
        this.outputInterpretation = outputInterpretation;
    }

    public String getSinkType() {
        return this.sinkType;
    }

    public void setSinkType(String sinkType) {
        this.sinkType = sinkType;
    }

    public String getInputFormatAttributeName() {
        return this.inputFormatAttributeName;
    }

    public void setInputFormatAttributeName(String inputFormatAttributeName) {
        this.inputFormatAttributeName = inputFormatAttributeName;
    }

    public String getOutputFormatAttributeName() {
        return this.outputFormatAttributeName;
    }

    public void setOutputFormatAttributeName(String outputFormatAttributeName) {
        this.outputFormatAttributeName = outputFormatAttributeName;
    }

    public DataSinkResolver getDataSinkResolver() {
        return this.dataSinkResolver;
    }

    public void setDataSinkResolver(DataSinkResolver dataSinkResolver) {
        this.dataSinkResolver = dataSinkResolver;
    }
}

