/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.objectstore;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindObjectStore
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(FindObjectStore.class);
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;

    private Map<String, String> getLinkedDataInfo(String repoId) {
        String query = "for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'LinkedDataDSResourceType' and .//REPOSITORY_SERVICE_IDENTIFIER = '" + repoId + "']" + "let $mdstore := $x//DATA_SOURCE/text()" + "let $objectStore := $x//DATA_SINK/text()" + "let $dataID := $x//RESOURCE_IDENTIFIER/@value/string()" + "return concat ($mdstore, '::', $objectStore, '::',$dataID)";
        try {
            String results = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query).trim();
            log.info((Object)("\n\nResult " + results));
            String[] values = results.split("::");
            if (values.length == 3) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("mdstore", values[0]);
                info.put("objectStore", values[1]);
                info.put("dataID", values[2]);
                return info;
            }
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.error((Object)"Info not found ", (Throwable)e);
        }
        catch (ISLookUpException e) {
            log.error((Object)"Got Exception on getLinkedDataInfo ", (Throwable)e);
        }
        return null;
    }

    private String findDataLinkObjectStore(String RepoId) {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'LinkedDataDSResourceType' and .//REPOSITORY_SERVICE_IDENTIFIER = '" + RepoId + "']//RESOURCE_IDENTIFIER/@value/string()";
        try {
            String linkObjectStoreId = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query).trim();
            return linkObjectStoreId;
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.debug((Object)"Profile not found");
        }
        catch (ISLookUpException e) {
            log.error((Object)"Got Exception in findDataLinkObjectStore", (Throwable)e);
        }
        return null;
    }

    public void execute(Engine engine, NodeToken token) {
        String repoId = token.getFullEnv().getAttribute("repoId");
        log.info((Object)("Repository ID is " + repoId));
        String lds = this.findDataLinkObjectStore(repoId);
        if (lds == null) {
            log.info((Object)"not found the Linked DS");
            engine.complete(token, "notFound");
        } else {
            token.getEnv().setAttribute("lds", lds);
            Map<String, String> info = this.getLinkedDataInfo(repoId);
            if (info != null) {
                token.getEnv().setAttribute("mdstoreId", info.get("mdstore"));
                token.getEnv().setAttribute("objectStoreId", info.get("objectStore"));
                token.getEnv().setAttribute("mdstoreId", info.get("mdstore"));
            }
            engine.complete(token, "found");
        }
    }
}

