/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.objectstore;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.manager.msro.openaire.objectstore.DownloadIterator;
import eu.dnetlib.enabling.manager.msro.openaire.objectstore.URLExtractor;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.workflow.BlackboardJobNode;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadPDF
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(DownloadPDF.class);
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource(name="objectstoremsroResultSetClientFactory")
    private ResultSetClientFactory resultSetClientFactory;
    @Resource(name="objectStoreiterableResultSetFactory")
    private IterableResultSetFactory resultSetFactory;

    protected String locateService(NodeToken token) {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'ObjectStoreServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()";
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'ObjectStoreServiceResourceType']//RESOURCE_IDENTIFIER/@value/string()");
        }
        catch (ISLookUpException e) {
            return null;
        }
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) {
        super.prepareJob(job, token);
        String epr = token.getEnv().getAttribute("epr");
        log.debug((Object)("EPR FOUND " + epr));
        IterableResultSetClient records = this.resultSetClientFactory.getClient(epr);
        String objectStoreId = token.getEnv().getAttribute("objectStoreId");
        log.info((Object)("Object Store ID " + objectStoreId));
        try {
            URLExtractor extractor = new URLExtractor();
            DownloadIterator di = new DownloadIterator();
            di.setExtractor(extractor);
            di.generateURLs(records.iterator());
            job.setAction("FEED");
            job.getParameters().put("obsID", objectStoreId);
            W3CEndpointReference eprUrls = this.resultSetFactory.createIterableResultSet((Iterable)di);
            job.getParameters().put("epr", new String(Base64.encodeBase64((byte[])eprUrls.toString().getBytes("US-ASCII")), "US-ASCII"));
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public IterableResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public void setResultSetFactory(IterableResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }
}

