/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.objectstore;

import com.google.gson.Gson;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import eu.dnetlib.enabling.manager.msro.openaire.objectstore.LinkedObject;
import eu.dnetlib.enabling.manager.msro.openaire.objectstore.URLExtractor;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadIterator
implements Iterable<String> {
    private static final Log log = LogFactory.getLog(DownloadIterator.class);
    private Iterator<String> records = null;
    private String currentObject = null;
    private Gson gson = new Gson();
    private URLExtractor extractor;

    public void generateURLs(Iterator<String> records) {
        this.records = records;
    }

    private String getNextObject() {
        try {
            if (this.records.hasNext()) {
                String nextObj = this.records.next();
                LinkedObject tmp = (LinkedObject)this.gson.fromJson(nextObj, LinkedObject.class);
                String newURL = this.extractor.provideContent(tmp.getURLS().get(0));
                String objectId = tmp.getObjectIdentifier() + "::" + Hashing.md5((String)newURL);
                ObjectStoreFile metadata = new ObjectStoreFile();
                metadata.setURI(newURL);
                metadata.setObjectID(objectId);
                metadata.setAccessProtocol(Protocols.HTTP);
                metadata.setMimeType("application/pdf");
                return metadata.toJSON();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                if (DownloadIterator.this.records == null) {
                    return false;
                }
                if (DownloadIterator.this.currentObject == null) {
                    if (!DownloadIterator.this.records.hasNext()) {
                        return false;
                    }
                    DownloadIterator.this.currentObject = DownloadIterator.this.getNextObject();
                    return DownloadIterator.this.currentObject != null;
                }
                return true;
            }

            @Override
            public String next() {
                String out = DownloadIterator.this.currentObject;
                DownloadIterator.this.currentObject = null;
                return out;
            }

            @Override
            public void remove() {
            }
        };
    }

    public URLExtractor getExtractor() {
        return this.extractor;
    }

    public void setExtractor(URLExtractor extractor) {
        this.extractor = extractor;
    }
}

