/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.mdstore;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.NodeToken;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import eu.dnetlib.data.mapreduce.wf.dataimport.hack.MDStoreInfo;
import eu.dnetlib.enabling.inspector.msro.progress.ProgressProvider;
import eu.dnetlib.workflow.AsyncJobNode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreMigrationExporter
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(MDStoreMigrationExporter.class);
    private DB inputDB;
    private DB outputDB;
    private List<MDStoreInfo> mdstores;

    protected void executeAsync(Engine engine, NodeToken token) {
        final Counter countRecords = new Counter();
        Counter countMDSstores = new Counter();
        this.setProgressProvider(new ProgressProvider(){
            int total = -1;

            public boolean isInaccurate() {
                return false;
            }

            public int getTotalValue(Node node, NodeToken token) {
                if (this.total < 0) {
                    for (MDStoreInfo info : MDStoreMigrationExporter.this.mdstores) {
                        this.total = (int)((long)this.total + MDStoreMigrationExporter.this.getInputDB().getCollection(info.calculateLongId()).count());
                    }
                }
                return this.total;
            }

            public int getCurrentValue(Node node, NodeToken token) {
                return countRecords.getVal();
            }
        });
        try {
            for (MDStoreInfo info : this.mdstores) {
                log.info((Object)("exporting mdstore " + info.calculateLongId() + " to " + this.getOutputDB().getName()));
                this.getOutputDB().getCollection("metadata").update((DBObject)new BasicDBObject("mdId", (Object)info.calculateLongId()), this.newMetaObject(info), true, false);
                this.write(info, countRecords);
                countMDSstores.increment(1);
            }
            log.info((Object)"*******************************************************************");
            log.info((Object)("processed " + countMDSstores.getVal() + " mdstores"));
            log.info((Object)("written " + countRecords.getVal() + " records"));
            log.info((Object)"*******************************************************************");
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
    }

    private void write(MDStoreInfo info, Counter countRecords) throws IOException {
        SAXReader reader = new SAXReader();
        String sourceMdId = info.calculateLongId();
        String targetMdId = info.calculateLongTargetId();
        long timestamp = System.currentTimeMillis();
        for (DBObject record : this.getInputDB().getCollection(sourceMdId).find()) {
            String id = (String)record.get("id");
            String xml = (String)record.get("body");
            if (id == null || id.isEmpty() || xml == null || xml.isEmpty()) {
                log.warn((Object)("invalid record (missing id or xml) !\n" + xml));
                continue;
            }
            try {
                Document doc = reader.read((Reader)new StringReader(xml));
                Element objIdentifier = (Element)doc.selectSingleNode("//*[local-name()='objIdentifier']");
                String newId = this.patchId(objIdentifier.getText(), info.getNamespacePrefix());
                objIdentifier.setText(newId);
                Element repositoryId = (Element)doc.selectSingleNode("//*[local-name()='repositoryId']");
                repositoryId.setText(info.calculateRepoLongId());
                Element recordIdentifier = (Element)doc.selectSingleNode("//*[local-name()='recordIdentifier']");
                recordIdentifier.setText(this.patchId(recordIdentifier.getText(), targetMdId));
                this.getOutputDB().getCollection(targetMdId).update((DBObject)new BasicDBObject("id", (Object)newId), this.newDBObject(newId, doc, timestamp), true, false);
                countRecords.increment(1);
            }
            catch (Exception e) {
                log.warn((Object)("invalid record: " + id));
                log.debug((Object)xml);
            }
        }
        log.info((Object)("mdId: " + info.getShortId() + " count: " + countRecords.getVal()));
    }

    private DBObject newDBObject(String id, Document doc, long timestamp) {
        HashMap m = Maps.newHashMap();
        m.put("id", id);
        m.put("originalId", "");
        m.put("body", doc.asXML());
        m.put("timestamp", timestamp);
        BasicDBObject obj = new BasicDBObject((Map)m);
        return obj;
    }

    private DBObject newMetaObject(MDStoreInfo info) {
        BasicDBObject meta = new BasicDBObject();
        meta.put("mdId", (Object)info.calculateLongId());
        meta.put("format", (Object)"oai_dc");
        meta.put("layout", (Object)"store");
        meta.put("interpretation", (Object)"native");
        return meta;
    }

    private String patchId(String id, String prefix) {
        String recordId = StringUtils.substringAfterLast((String)id, (String)"::");
        if (recordId == null || recordId.isEmpty()) {
            log.warn((Object)("invalid id: " + id));
            return id;
        }
        return prefix + "::" + recordId;
    }

    public List<MDStoreInfo> getMdstores() {
        return this.mdstores;
    }

    @Required
    public void setMdstores(List<MDStoreInfo> mdstores) {
        this.mdstores = mdstores;
    }

    public DB getInputDB() {
        return this.inputDB;
    }

    @Required
    public void setInputDB(DB inputDB) {
        this.inputDB = inputDB;
    }

    public DB getOutputDB() {
        return this.outputDB;
    }

    @Required
    public void setOutputDB(DB outputDB) {
        this.outputDB = outputDB;
    }

    private class Counter {
        private int val = 0;

        private Counter() {
        }

        public int getVal() {
            return this.val;
        }

        public void increment(int n) {
            this.val += n;
        }
    }
}

