/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.is.vocabularies;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class UpdateVocabularyProfilesJobNode
extends AbstractJobNode {
    private static final String VOCABULARY_DS_RESOURCE_TYPE = "VocabularyDSResourceType";
    private ResultSetClientFactory resultSetClientFactory;
    private ServiceLocator<ISRegistryService> registryLocator;
    private static final Log log = LogFactory.getLog(UpdateVocabularyProfilesJobNode.class);

    public void execute(Engine engine, NodeToken token) {
        SAXReader reader = new SAXReader();
        try {
            W3CEndpointReference epr = (W3CEndpointReference)token.getFullEnv().getTransientAttribute("vocabulariesEPR");
            Map existingVocabularies = (Map)token.getFullEnv().getTransientAttribute("existingVocabularies");
            for (String profile : this.resultSetClientFactory.getClient(epr)) {
                String profId;
                Document doc = reader.read((Reader)new StringReader(profile));
                String vocName = doc.valueOf("//VOCABULARY_NAME");
                log.debug((Object)("Registering/updating profile:\n " + profile + "\n"));
                if (existingVocabularies.containsKey(vocName)) {
                    profId = (String)existingVocabularies.get(vocName);
                    ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, doc.asXML(), VOCABULARY_DS_RESOURCE_TYPE);
                    log.info((Object)("Vocabulary profile " + profId + " [" + vocName + "] updated"));
                    continue;
                }
                profId = ((ISRegistryService)this.registryLocator.getService()).registerProfile(doc.asXML());
                log.info((Object)("Vocabulary profile [" + vocName + "] registered with id: " + profId));
            }
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

