/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.is.repositories;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.manager.msro.openaire.is.repositories.FindExistingRepositoriesJobNode;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.workflow.AbstractJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class UpdateRepositoryProfilesJobNode
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(UpdateRepositoryProfilesJobNode.class);
    private static final String REPOSITORY_SERVICE_RESOURCE_TYPE = "RepositoryServiceResourceType";
    private ResultSetClientFactory resultSetClientFactory;
    private ServiceLocator<ISRegistryService> registryLocator;

    public void execute(Engine engine, NodeToken token) {
        SAXReader reader = new SAXReader();
        try {
            W3CEndpointReference epr = (W3CEndpointReference)token.getFullEnv().getTransientAttribute("reposEPR");
            Map existingRepos = (Map)token.getFullEnv().getTransientAttribute("existingRepos");
            for (String profile : this.resultSetClientFactory.getClient(epr)) {
                Document doc = this.parse(reader, profile);
                String dsId = doc.valueOf("//EXTRA_FIELDS/FIELD[./key='OpenAireDataSourceId']/value");
                log.debug((Object)("Registering/updating profile:\n " + profile + "\n"));
                if (existingRepos.containsKey(dsId)) {
                    FindExistingRepositoriesJobNode.RepositoryInfo info = (FindExistingRepositoriesJobNode.RepositoryInfo)existingRepos.get(dsId);
                    doc.selectSingleNode("//RESOURCE_IDENTIFIER/@value").setText(info.repoId);
                    doc.selectSingleNode("//RESOURCE_KIND/@value").setText(info.resourceKind);
                    log.info((Object)("Updating profile " + info.repoId + " UPDATED for ds " + dsId));
                    ((ISRegistryService)this.registryLocator.getService()).updateProfile(info.repoId, doc.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
                    log.debug((Object)("Profile " + info.repoId + " UPDATED for ds " + dsId));
                    continue;
                }
                log.info((Object)("Registering repository profile for ds " + dsId));
                String profId = ((ISRegistryService)this.registryLocator.getService()).insertProfileForValidation(REPOSITORY_SERVICE_RESOURCE_TYPE, doc.asXML());
                log.debug((Object)("Profile " + profId + " REGISTERED for ds " + dsId));
            }
            engine.complete(token, Arc.DEFAULT_ARC);
        }
        catch (Throwable e) {
            this.failed(engine, token, e);
        }
    }

    private Document parse(SAXReader reader, String profile) {
        try {
            return reader.read((Reader)new StringReader(profile));
        }
        catch (DocumentException e) {
            log.error((Object)("cannot parse: " + profile));
            throw new IllegalArgumentException(e);
        }
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

