/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.manager.msro.openaire.is.repositories;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class RepositoryXsltFunctions {
    private static final Log log = LogFactory.getLog(RepositoryXsltFunctions.class);
    private static Resource ifaceTemplate = new ClassPathResource("/eu/dnetlib/enabling/manager/msro/openaire/is/repositories/interface.st");
    private static Resource paramTemplate = new ClassPathResource("/eu/dnetlib/enabling/manager/msro/openaire/is/repositories/param.st");

    public static String buildInterface(String infopackage) {
        ArrayList formats = Lists.newArrayList();
        ArrayList sets = Lists.newArrayList();
        block4: for (String param : RepositoryXsltFunctions.parseParams(infopackage)) {
            StringTemplate p = RepositoryXsltFunctions.getTemplate(paramTemplate);
            String paramName = StringUtils.substringBefore((String)param, (String)"=").toUpperCase();
            p.setAttribute("param", (Object)paramName);
            p.setAttribute("value", (Object)StringUtils.substringAfter((String)param, (String)"=").trim());
            switch (Params.valueOf(paramName)) {
                case FORMAT: {
                    formats.add(p.toString());
                    continue block4;
                }
                case SET: {
                    sets.add(p.toString());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("unsupported param: " + paramName);
        }
        StringTemplate i = RepositoryXsltFunctions.getTemplate(ifaceTemplate);
        i.setAttribute("id", (Object)RepositoryXsltFunctions.getId(infopackage));
        i.setAttribute("accessProtocol", (Object)RepositoryXsltFunctions.getAccessProtocol(infopackage));
        i.setAttribute("baseUrl", (Object)RepositoryXsltFunctions.getBaseUrl(infopackage));
        i.setAttribute("formats", RepositoryXsltFunctions.ensureMinOccurs(formats, "<FORMAT/>"));
        i.setAttribute("sets", RepositoryXsltFunctions.ensureMinOccurs(sets, "<SET/>"));
        String iface = i.toString();
        return iface;
    }

    private static String getId(String infopackage) {
        return StringUtils.substringBefore((String)infopackage, (String)"===");
    }

    private static List<String> ensureMinOccurs(List<String> list, String empty) {
        if (list.isEmpty()) {
            list.add(empty);
        }
        return list;
    }

    private static String ensureMinOccurs(String s, String empty) {
        if (s.isEmpty()) {
            return empty;
        }
        return s;
    }

    public static String buildDatacoll(String infopackage) {
        String datacolls = "";
        String accessProtocol = RepositoryXsltFunctions.getAccessProtocol(infopackage);
        String baseUrl = RepositoryXsltFunctions.getBaseUrl(infopackage);
        for (String param : RepositoryXsltFunctions.parseParams(infopackage)) {
            StringTemplate p = RepositoryXsltFunctions.getTemplate(paramTemplate);
            String paramName = StringUtils.substringBefore((String)param, (String)"=").toUpperCase();
            if (!paramName.equals(Params.FORMAT.toString())) continue;
            p.setAttribute("param", (Object)paramName);
            p.setAttribute("value", (Object)StringUtils.substringAfter((String)param, (String)"="));
            datacolls = datacolls + RepositoryXsltFunctions.getInterface(accessProtocol + baseUrl + p.toString());
        }
        return RepositoryXsltFunctions.ensureMinOccurs(datacolls, "<INTERFACE><ACCESS_PROTOCOL/><BASE_URL/><FORMAT/></INTERFACE>");
    }

    private static Iterable<String> parseParams(String infopackage) {
        return Splitter.on((String)"***").omitEmptyStrings().trimResults().split((CharSequence)StringUtils.substringAfter((String)infopackage, (String)"@@@"));
    }

    private static String getInterface(String value) {
        StringTemplate i = RepositoryXsltFunctions.getTemplate(paramTemplate);
        i.setAttribute("param", (Object)"INTERFACE");
        i.setAttribute("value", (Object)value);
        return i.toString();
    }

    private static String getBaseUrl(String infopackage) {
        StringTemplate b = RepositoryXsltFunctions.getTemplate(paramTemplate);
        b.setAttribute("param", (Object)"BASE_URL");
        b.setAttribute("value", (Object)StringUtils.substringBefore((String)StringUtils.substringAfter((String)infopackage, (String)"==="), (String)"###"));
        return b.toString();
    }

    private static String getAccessProtocol(String infopackage) {
        StringTemplate a = RepositoryXsltFunctions.getTemplate(paramTemplate);
        a.setAttribute("param", (Object)"ACCESS_PROTOCOL");
        a.setAttribute("value", (Object)StringUtils.substringBefore((String)StringUtils.substringAfter((String)infopackage, (String)"###"), (String)"@@@"));
        return a.toString();
    }

    private static StringTemplate getTemplate(Resource res) {
        StringWriter body = new StringWriter();
        try {
            IOUtils.copy((InputStream)res.getInputStream(), (Writer)body);
            String string = body.toString();
            return new StringTemplate(string);
        }
        catch (IOException e) {
            log.error((Object)"unable to get template", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static enum Params {
        FORMAT,
        SET;

    }
}

